/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.AbstractNavigationUtil;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.assertions.DashboardAssertions;
import com.atlassian.jira.functest.framework.dashboard.DashboardPageInfo;
import com.atlassian.jira.functest.framework.dashboard.DashboardPagePortletInfo;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardAssertionsImpl
extends AbstractNavigationUtil
implements DashboardAssertions {
    private static final Pattern PATTERN_FAVCOUNT = Pattern.compile("(\\d+)\\s+\\d+");

    public DashboardAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData);
    }

    @Override
    public void assertDashboardPortlets(Long id, DashboardPagePortletInfo dashboardPortletInfo) {
        this.getNavigation().dashboard().navigateToFullConfigure(id);
        this.assertPortletsOnCurrentPage(dashboardPortletInfo);
    }

    @Override
    public void assertDefaultDashboardPortlets(DashboardPagePortletInfo dashboardPortletInfo) {
        this.getNavigation().dashboard().navigateToDefaultFullConfigure();
        this.assertPortletsOnCurrentPage(dashboardPortletInfo);
    }

    private void assertPortletsOnCurrentPage(DashboardPagePortletInfo dashboardPortletInfo) {
        this.tester.setWorkingForm("jiraform");
        List leftOptions = EasyList.build((Object[])this.tester.getDialog().getOptionsFor("selectedLeftPortlets"));
        Assert.assertEquals((String)"Portlets on left did not match.", (Object)dashboardPortletInfo.getLeftPortlets(), (Object)leftOptions);
        List rightOptions = EasyList.build((Object[])this.tester.getDialog().getOptionsFor("selectedRightPortlets"));
        Assert.assertEquals((String)"Portlets on right did not match.", (Object)dashboardPortletInfo.getRightPortlets(), (Object)rightOptions);
    }

    @Override
    public void assertColumns(List<String> colHeaders, Locator dashboardsLocator) {
        Assert.assertEquals(colHeaders, this.getColumnHeaders(dashboardsLocator));
    }

    @Override
    public void assertDashboardPages(List<? extends SharedEntityInfo> pages, Dashboard.Table table) {
        WebTable webTable;
        try {
            webTable = this.tester.getDialog().getResponse().getTableWithID(table.getTableId());
        }
        catch (SAXException e) {
            Assert.fail((String)("Unable to locate table '" + table + "'."));
            return;
        }
        Assert.assertEquals((String)("Dashboard incorrect number of pages in table '" + table + "'."), (int)pages.size(), (int)(webTable.getRowCount() - 1));
        int columns = webTable.getColumnCount();
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        for (int i = 0; i < columns; ++i) {
            String text = webTable.getCellAsText(0, i);
            if (text == null) continue;
            columnMap.put(text.trim(), i);
        }
        XPathLocator locator = new XPathLocator(this.tester, table.toXPath() + "/tr");
        Node[] nodes = locator.getNodes();
        int row = 1;
        for (SharedEntityInfo sharedEntityInfo : pages) {
            DashboardPageInfo dashboardPageInfo;
            if (sharedEntityInfo.getId() != null) {
                this.checkId(sharedEntityInfo, nodes[row], row);
            }
            if (StringUtils.isNotEmpty((String)sharedEntityInfo.getName())) {
                DashboardAssertionsImpl.checkNameColumn(sharedEntityInfo, webTable, row, DashboardAssertionsImpl.getColumnNumber("Name", columnMap));
            }
            if (StringUtils.isNotEmpty((String)sharedEntityInfo.getOwner())) {
                this.checkAuthorColumn(sharedEntityInfo, webTable, row, DashboardAssertionsImpl.getColumnNumber("Author", columnMap));
            }
            if (sharedEntityInfo.getSharingPermissions() != null) {
                this.checkShares(sharedEntityInfo, webTable, row, DashboardAssertionsImpl.getColumnNumber("Shared With", columnMap));
            }
            if (sharedEntityInfo.getFavCount() != null) {
                this.checkFavouriteCount(sharedEntityInfo, webTable, row, DashboardAssertionsImpl.getColumnNumber("Popularity", columnMap));
            }
            if (sharedEntityInfo instanceof DashboardPageInfo && (dashboardPageInfo = (DashboardPageInfo)sharedEntityInfo).getOperations() != null) {
                this.checkOperations(dashboardPageInfo, webTable, row, DashboardAssertionsImpl.getColumnNumber("Operations", columnMap));
            }
            ++row;
        }
    }

    private void checkId(SharedEntityInfo sharedEntityInfo, Node node, int row) {
        long id = sharedEntityInfo.getId();
        Attr idAttribute = (Attr)node.getAttributes().getNamedItem("id");
        Assert.assertNotNull((String)("Expected page with id '" + id + "' in row '" + row + "'."), (Object)idAttribute);
        Assert.assertEquals((String)("Expected page with id '" + id + "' in row '" + row + "'."), (String)("pp_" + id), (String)idAttribute.getValue());
    }

    private void checkOperations(DashboardPageInfo dashboardPageInfo, WebTable webTable, int row, int column) {
        TableCell cell = webTable.getTableCell(row, column);
        for (DashboardPageInfo.Operation operation : DashboardPageInfo.Operation.ALL) {
            WebLink webLink;
            if (dashboardPageInfo.getOperations().contains(operation)) {
                webLink = cell.getLinkWith(operation.getLinkName());
                Assert.assertNotNull((String)("Dasboard at row '" + row + "' does not appear to have operation '" + operation + "'."), (Object)webLink);
                String expectedLink = operation.getUrl(dashboardPageInfo.getId());
                Assert.assertTrue((String)("Operation '" + operation + "' for dashboard at row '" + row + "' does not link to '" + expectedLink + "'."), (boolean)webLink.getURLString().endsWith(expectedLink));
                continue;
            }
            webLink = cell.getLinkWith(operation.getLinkName());
            Assert.assertNull((String)("Dasboard at row '" + row + "' does appears to have operation '" + operation + "'."), (Object)webLink);
        }
    }

    private void checkFavouriteCount(SharedEntityInfo dashboardPageInfo, WebTable webTable, int row, int column) {
        String text = webTable.getCellAsText(row, column).trim();
        Matcher matcher = PATTERN_FAVCOUNT.matcher(text);
        if (matcher.find()) {
            try {
                int count = Integer.parseInt(matcher.group(1));
                Assert.assertEquals((String)("Dashboard at row " + row + " does not appear to have a favourite count of " + dashboardPageInfo.getFavCount() + "."), (int)dashboardPageInfo.getFavCount(), (int)count);
            }
            catch (NumberFormatException e) {
                Assert.fail((String)("Dashboard at row " + row + " does not appear to have a favourite count of " + dashboardPageInfo.getFavCount() + "."));
            }
        } else {
            Assert.fail((String)("Dashboard at row " + row + " does not appear to have a favourite count of " + dashboardPageInfo.getFavCount() + "."));
        }
    }

    private void checkShares(SharedEntityInfo dashboardPageInfo, WebTable webTable, int row, int column) {
        String text = webTable.getCellAsText(row, column).trim();
        Set<? extends TestSharingPermission> permissions = dashboardPageInfo.getSharingPermissions();
        if (permissions.isEmpty()) {
            Assert.assertTrue((String)("Dashboard at row " + row + " does not appear to be shared privately."), (text.indexOf("Private") >= 0 ? 1 : 0) != 0);
        } else {
            for (TestSharingPermission testSharingPermission : permissions) {
                Assert.assertTrue((String)("Dashboard at row " + row + " does not appear to shared as '" + testSharingPermission + "'."), (text.indexOf(testSharingPermission.toDisplayFormat()) >= 0 ? 1 : 0) != 0);
            }
        }
    }

    private void checkAuthorColumn(SharedEntityInfo dashboardPageInfo, WebTable webTable, int row, int column) {
        String text = webTable.getCellAsText(row, column).trim();
        Assert.assertTrue((String)("Dashboard at row " + row + " does not appear to owned by '" + dashboardPageInfo.getOwner() + "'."), (text.indexOf(dashboardPageInfo.getOwner()) >= 0 ? 1 : 0) != 0);
    }

    private static void checkNameColumn(SharedEntityInfo dashboardPageInfo, WebTable webTable, int row, int column) {
        String text = webTable.getCellAsText(row, column).trim();
        Assert.assertTrue((String)("Dashboard at row " + row + " does not appear to be called '" + dashboardPageInfo.getName() + "'."), (text.indexOf(dashboardPageInfo.getName()) >= 0 ? 1 : 0) != 0);
        TableCell tableCell = webTable.getTableCell(row, column);
        if (dashboardPageInfo.isFavourite()) {
            Assert.assertTrue((String)("Dashboard at row " + row + " does not appear to be a favourite'."), (tableCell.getLinks()[0].getTitle() != null && tableCell.getLinks()[0].getTitle().contains("Remove this dashboard from your favourites") ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Dashboard at row " + row + " appears to be a favourite'."), (tableCell.getLinks()[0].getTitle() != null && tableCell.getLinks()[0].getTitle().contains("Add this dashboard to your favourites") ? 1 : 0) != 0);
        }
        if (StringUtils.isNotEmpty((String)dashboardPageInfo.getDescription())) {
            Assert.assertTrue((String)("Dashboard at row " + row + " does not have description '" + dashboardPageInfo.getDescription() + "'."), (text.indexOf(dashboardPageInfo.getDescription()) >= 0 ? 1 : 0) != 0);
        }
    }

    private static int getColumnNumber(String columnName, Map columnMap) {
        Integer column = (Integer)columnMap.get(columnName);
        if (column == null) {
            Assert.fail((String)("Dashboard table does not appear to have a '" + columnName + "' column."));
        }
        return column;
    }

    private List<String> getColumnHeaders(Locator dashboardsLocator) {
        Node[] colHeaders = this.getHeaderColumnsLocator(dashboardsLocator).getNodes();
        ArrayList<String> results = new ArrayList<String>(colHeaders.length);
        for (Node colHeader : colHeaders) {
            String o = DomKit.getCollapsedText(colHeader);
            results.add(o != null ? o.trim() : null);
        }
        return results;
    }

    private Locator getHeaderColumnsLocator(Locator dashboardsLocator) {
        XPathLocator rowLocator = new XPathLocator(dashboardsLocator.getNode(), "tr[1]");
        Node row = rowLocator.getNode();
        return new XPathLocator(row, "td");
    }
}

