/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.DashboardAssertions;
import com.atlassian.jira.functest.framework.assertions.DashboardAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.JiraFormAssertions;
import com.atlassian.jira.functest.framework.assertions.JiraFormAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.LinkAssertions;
import com.atlassian.jira.functest.framework.assertions.LinkAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.TableAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.URLAssertions;
import com.atlassian.jira.functest.framework.assertions.URLAssertionsImpl;
import com.atlassian.jira.functest.framework.assertions.ViewIssueAssertions;
import com.atlassian.jira.functest.framework.dump.ArtifactDumper;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.WebTester;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionsImpl
extends AbstractFuncTestUtil
implements Assertions {
    private final Navigation navigation;
    private TextAssertions textAssertions = null;
    private URLAssertionsImpl urlAssertions = null;
    private JiraFormAssertionsImpl jiraFormAssertions = null;
    private IssueNavigatorAssertionsImpl issueNavigatorAssertions = null;
    private DashboardAssertionsImpl dashboardAssertions = null;
    private LinkAssertions linkAssertions = null;
    private TableAssertions tableAssertions = null;

    public AssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation) {
        super(tester, environmentData, 2);
        this.navigation = navigation;
    }

    @Override
    public void dumpResponse(TestCase testCase, WebTester tester, Throwable cause) {
        String htmlResponse = tester.getDialog().getResponseText();
        new ArtifactDumper(testCase, htmlResponse, cause, new Date(), this.getEnvironmentData(), this.getLogger(), tester);
    }

    @Override
    public void assertLastChangeHistoryRecords(String issueKey, ExpectedChangeHistoryRecord expectedChangeHistoryRecord) {
        if (expectedChangeHistoryRecord != null) {
            this.assertLastChangeHistoryRecords(issueKey, Arrays.asList(expectedChangeHistoryRecord));
        } else {
            this.assertLastChangeHistoryRecords(issueKey, (List)null);
        }
    }

    @Override
    public void assertLastChangeHistoryRecords(String issueKey, List expectedChangeHistoryRecords) {
        WebTable[] changeHistoryTables;
        this.navigation.issue().gotoIssueChangeHistory(issueKey);
        try {
            changeHistoryTables = this.tester.getDialog().getResponse().getMatchingTables(new HTMLElementPredicate(){

                public boolean matchesCriteria(Object htmlElement, Object criteria) {
                    HTMLElement element = (HTMLElement)htmlElement;
                    String id = element.getID();
                    return id != null && id.startsWith((String)criteria);
                }
            }, (Object)"changehistory_");
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        if (expectedChangeHistoryRecords != null && !expectedChangeHistoryRecords.isEmpty()) {
            int l = changeHistoryTables.length - 1;
            for (int i = expectedChangeHistoryRecords.size() - 1; i >= 0; --i) {
                ExpectedChangeHistoryRecord expectedChangeHistoryRecord = (ExpectedChangeHistoryRecord)expectedChangeHistoryRecords.get(i);
                WebTable lastChangeHistoryTable = changeHistoryTables[l];
                ArrayList<ExpectedChangeHistoryItem> expectedChangeItems = new ArrayList<ExpectedChangeHistoryItem>(expectedChangeHistoryRecord.getChangeItems());
                Collections.reverse(expectedChangeItems);
                int j = lastChangeHistoryTable.getRowCount() - 1;
                for (int k = 0; k < expectedChangeItems.size(); ++k) {
                    String fieldName = lastChangeHistoryTable.getCellAsText(j, 0).trim();
                    String oldValue = lastChangeHistoryTable.getCellAsText(j, 1).trim();
                    String newValue = lastChangeHistoryTable.getCellAsText(j, 2).trim();
                    Assert.assertTrue((boolean)this.isChangeItemPresent(fieldName, oldValue, newValue, expectedChangeItems));
                    --j;
                }
                String message = "Change history record appears to have extra change items";
                Assert.assertTrue((String)"Change history record appears to have extra change items", (j == -1 || j == 0 ? 1 : 0) != 0);
                if (j == 0) {
                    Assert.assertEquals((String)"Change history record appears to have extra change items", (String)"Field", (String)lastChangeHistoryTable.getCellAsText(j, 0).trim());
                    Assert.assertEquals((String)"Change history record appears to have extra change items", (String)"Original Value", (String)lastChangeHistoryTable.getCellAsText(j, 1).trim());
                    Assert.assertEquals((String)"Change history record appears to have extra change items", (String)"New Value", (String)lastChangeHistoryTable.getCellAsText(j, 2).trim());
                }
                --l;
            }
        } else {
            Assert.assertTrue((String)("The issue '" + issueKey + "' has change history records"), (changeHistoryTables == null ? 1 : 0) != 0);
        }
    }

    @Override
    public IssueNavigatorAssertions getIssueNavigatorAssertions() {
        if (this.issueNavigatorAssertions == null) {
            this.issueNavigatorAssertions = new IssueNavigatorAssertionsImpl(this.tester, this.environmentData);
        }
        return this.issueNavigatorAssertions;
    }

    @Override
    public ViewIssueAssertions getViewIssueAssertions() {
        return new ViewIssueAssertions(this.tester);
    }

    @Override
    public DashboardAssertions getDashboardAssertions() {
        if (this.dashboardAssertions == null) {
            this.dashboardAssertions = new DashboardAssertionsImpl(this.tester, this.environmentData);
        }
        return this.dashboardAssertions;
    }

    @Override
    public JiraFormAssertions getJiraFormAssertions() {
        if (this.jiraFormAssertions == null) {
            this.jiraFormAssertions = new JiraFormAssertionsImpl(this.getTextAssertions(), this.tester, this.environmentData);
        }
        return this.jiraFormAssertions;
    }

    @Override
    public URLAssertions getURLAssertions() {
        if (this.urlAssertions == null) {
            this.urlAssertions = new URLAssertionsImpl(this.tester, this.environmentData);
        }
        return this.urlAssertions;
    }

    @Override
    public TextAssertions getTextAssertions() {
        if (this.textAssertions == null) {
            this.textAssertions = new TextAssertionsImpl(this.tester);
        }
        return this.textAssertions;
    }

    @Override
    public LinkAssertions getLinkAssertions() {
        if (this.linkAssertions == null) {
            this.linkAssertions = new LinkAssertionsImpl(this.tester, this.getEnvironmentData());
        }
        return this.linkAssertions;
    }

    @Override
    public TableAssertions getTableAssertions() {
        if (this.tableAssertions == null) {
            this.tableAssertions = new TableAssertions(this.tester, this.getEnvironmentData());
        }
        return this.tableAssertions;
    }

    private boolean isChangeItemPresent(String fieldName, String oldValue, String newValue, List<ExpectedChangeHistoryItem> expectedChangeItems) {
        for (ExpectedChangeHistoryItem item : expectedChangeItems) {
            if (!item.getFieldName().equals(fieldName) || !this.equalsChangeHistoryValues(item.getOldValue(), oldValue) || !this.equalsChangeHistoryValues(item.getNewValue(), newValue)) continue;
            return true;
        }
        return false;
    }

    private boolean equalsChangeHistoryValues(String expectedValue, String actualValue) {
        return expectedValue == null || expectedValue.trim().length() == 0 ? actualValue == null || actualValue.trim().length() == 0 : actualValue.startsWith(expectedValue);
    }

    @Override
    public void assertEquals(String failureMessage, List expected, List actual) {
        if (!((Object)expected).equals(actual)) {
            if (expected.isEmpty() || actual.isEmpty()) {
                Assert.assertEquals((String)failureMessage, (Object)expected, (Object)actual);
            }
            for (int i = 0; i < expected.size(); ++i) {
                boolean lastExpected;
                if (i >= actual.size()) {
                    Assert.assertEquals((String)(failureMessage + " expected more items."), (Object)expected, (Object)actual);
                }
                if (!expected.get(i).equals(actual.get(i))) {
                    String mesg = failureMessage + " item " + i + " not equal";
                    Assert.assertEquals((String)mesg, (Object)expected, (Object)actual);
                }
                boolean bl = lastExpected = i == expected.size() - 1;
                if (!lastExpected || actual.size() <= expected.size()) continue;
                Assert.assertEquals((String)(failureMessage + " extra elements in actual (expected list is a prefix)."), (Object)expected, (Object)actual);
            }
        }
    }

    @Override
    public void assertProfileLinkPresent(String id, String linkText) {
        try {
            String returnUrl = this.navigation.getCurrentPage();
            WebLink link = this.tester.getDialog().getResponse().getLinkWithID(id);
            Assert.assertNotNull((String)("No link with id '" + id + "' present."), (Object)link);
            Assert.assertEquals((String)("Link text for link with id '" + id + "' does not match '" + linkText + "'."), (String)linkText, (String)link.asText());
            this.tester.clickLink(id);
            this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), "Username", linkText);
            this.tester.gotoPage(returnUrl);
        }
        catch (SAXException e) {
            Assert.fail((String)("Exception checking for link '" + id + "': " + e));
        }
    }

    @Override
    public void assertNodeExists(String xpath) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        Assert.assertTrue((boolean)locator.exists());
    }

    @Override
    public void assertNodeDoesNotExist(String xpath) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        Assert.assertFalse((boolean)locator.exists());
    }

    @Override
    public void assertNodeHasText(String xpath, String textToTest) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        Assert.assertTrue((boolean)locator.exists());
        this.textAssertions.assertTextPresent(locator, textToTest);
    }

    @Override
    public void assertNodeDoesNotHaveText(String xpath, String textToTest) {
        XPathLocator locator = new XPathLocator(this.tester, xpath);
        Assert.assertTrue((boolean)locator.exists());
        this.textAssertions.assertTextNotPresent(locator, textToTest);
    }
}

