/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.admin.UsersAndGroups;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class UsersAndGroupsImpl
extends AbstractFuncTestUtil
implements UsersAndGroups {
    private static final String PAGE_USER_BROWSER = "/secure/admin/user/UserBrowser.jspa";
    private static final String DELETE_GROUP = "/secure/admin/user/DeleteGroup!default.jspa?name=";
    private static final String PAGE_VIEW_USER = "/secure/admin/user/ViewUser.jspa?name=";
    private final TextAssertions text;

    public UsersAndGroupsImpl(WebTester tester, JIRAEnvironmentData environmentData, TextAssertions text, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
        this.text = text;
    }

    public void addUser(String username) {
        this.addUser(username, username, username, username + "@example.com");
    }

    public void addUser(String username, String password, String fullname, String emailAddress) {
        this.log("Adding User " + username);
        this.tester.gotoPage(PAGE_USER_BROWSER);
        this.tester.clickLink("add_user");
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("password", password);
        this.tester.setFormElement("confirm", password);
        this.tester.setFormElement("fullname", fullname);
        this.tester.setFormElement("email", emailAddress);
        this.tester.submit();
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Username:", username, "Full Name:", fullname, "Email:", emailAddress});
    }

    public void deleteUser(String username) {
        this.log("Deleting User " + username);
        this.tester.gotoPage(PAGE_USER_BROWSER);
        this.tester.clickLink("deleteuser_link_" + username);
        this.tester.assertTextPresent("Delete User: " + username);
        this.tester.submit("Delete");
        this.gotoViewUser(username);
        this.tester.assertTextPresent("User does not exist");
    }

    public void deleteUserConfirm(String username) {
        this.log("Delete confirmation of User " + username);
        this.tester.gotoPage(PAGE_USER_BROWSER);
        this.tester.clickLink("deleteuser_link_" + username);
        this.tester.assertTextPresent("Delete User: " + username);
    }

    public void deleteGroup(String groupname) {
        this.log("Deleting group " + groupname);
        this.tester.gotoPage(DELETE_GROUP + groupname);
        this.tester.assertTextPresent("Delete Group: " + groupname);
        this.tester.submit("Delete");
    }

    public void gotoViewUser(String username) {
        this.tester.gotoPage(PAGE_VIEW_USER + username);
    }

    public void addUserToGroup(String userName, String groupName) {
        this.gotoViewUser(userName);
        this.tester.clickLink("editgroups_link");
        try {
            this.tester.selectOption("groupsToJoin", groupName);
            this.tester.submit("join");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent(groupName);
    }

    public void addGroup(String groupName) {
        this.tester.gotoPage("/secure/admin/user/GroupBrowser.jspa");
        if (this.tester.getDialog().isLinkPresentWithText(groupName)) {
            this.tester.clickLinkWithText(groupName);
            this.tester.clickLink("del_" + groupName);
            this.tester.submit("Delete");
        }
        this.tester.setFormElement("addName", groupName);
        this.tester.submit();
        this.tester.assertLinkPresentWithText(groupName);
    }
}

