/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.admin.Roles;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class RolesImpl
extends AbstractFuncTestUtil
implements Roles {
    private static final String DELETE_ROLE = "/secure/project/DeleteProjectRole!default.jspa?id=";
    private static final String ADD_ROLE = "/secure/project/UserRoleActorAction!addUsers.jspa?projectRoleId=";

    public RolesImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        super(tester, environmentData, logIndentLevel);
    }

    public void deleteRole(long roleId) {
        this.log("Deleting role " + roleId);
        this.tester.gotoPage(DELETE_ROLE + roleId);
        this.tester.submit("Delete");
    }

    public void addProjectRoleForUser(String projectName, int roleId, String userName) {
        boolean projectExists = this.getFuncTestHelperFactory().getAdministration().project().projectExists(projectName);
        if (projectExists) {
            this.tester.clickLink("view_projects");
            this.tester.clickLinkWithText(projectName);
            String text = this.tester.getDialog().getResponse().getURL().toString();
            int projectIdLocation = text.indexOf("pid=") + "pid=".length();
            String projectId = text.substring(projectIdLocation, projectIdLocation + 5);
            this.tester.gotoPage(ADD_ROLE + roleId + "&projectId=" + projectId + "&id=" + roleId + "&userNames=" + userName);
            this.tester.assertLinkPresent("watcher_link_" + userName);
        } else {
            Assert.fail((String)("A project with the name '" + projectName + "' does not exist."));
        }
    }
}

