/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class GeneralConfigurationImpl
extends AbstractFuncTestUtil
implements GeneralConfiguration {
    public GeneralConfigurationImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    public void setAllowUnassignedIssues(boolean enable) {
        this.getNavigation().gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.getDialog().setFormParameter("allowUnassigned", String.valueOf(enable));
        this.tester.submit("Update");
    }

    public void setExternalUserManagement(boolean enable) {
        this.getNavigation().gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        if (enable) {
            this.tester.checkCheckbox("externalUM", "true");
            this.tester.selectOption("mode", "Private");
        } else {
            this.tester.checkCheckbox("externalUM", "false");
        }
        this.tester.submit("Update");
    }

    public void enableVoting() {
        this.getNavigation().gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.getDialog().setFormParameter("voting", "true");
        this.tester.submit("Update");
    }

    public void setUserSearchingByFullName(boolean enable) {
        this.getNavigation().gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.getDialog().setFormParameter("ajaxUserPicker", String.valueOf(enable));
        this.tester.submit("Update");
    }

    public void setJqlAutocomplete(boolean enable) {
        this.getNavigation().gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.getDialog().setFormParameter("jqlAutocompleteDisabled", String.valueOf(!enable));
        this.tester.submit("Update");
    }

    public void disableVoting() {
        this.getNavigation().gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.getDialog().setFormParameter("voting", "false");
        this.tester.submit("Update");
    }

    public void setBaseUrl(String baseUrl) {
        this.log("Setting baseurl to '" + baseUrl + "'");
        this.getNavigation().gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.setFormElement("baseURL", baseUrl);
        this.tester.submit("Update");
    }

    public void setJiraLocale(String locale) {
        this.log("Setting locale to '" + locale + "'");
        this.getNavigation().gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.selectOption("defaultLocale", locale);
        this.tester.submit("Update");
    }

    public void disableWatching() {
        this.getNavigation().gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.getDialog().setFormParameter("watching", "false");
        this.tester.submit("Update");
    }

    public void enableWatching() {
        this.getNavigation().gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.getDialog().setFormParameter("watching", "true");
        this.tester.submit("Update");
    }

    protected Navigation getNavigation() {
        return this.getFuncTestHelperFactory().getNavigation();
    }
}

