/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.FieldConfigurations;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;

public class FieldConfigurationsImpl
extends AbstractFuncTestUtil
implements FieldConfigurations,
FieldConfigurations.FieldConfiguration {
    public FieldConfigurationsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    protected Navigation getNavigation() {
        return this.getFuncTestHelperFactory().getNavigation();
    }

    public FieldConfigurations.FieldConfiguration defaultFieldConfiguration() {
        this.getNavigation().gotoAdminSection("field_configuration");
        this.tester.clickLink("configure-Default Field Configuration");
        return this;
    }

    public FieldConfigurations.FieldConfiguration fieldConfiguration(String fieldConfigurationName) {
        this.getNavigation().gotoAdminSection("field_configuration");
        this.tester.clickLink("configure-" + fieldConfigurationName);
        return this;
    }

    public void showField(int id) {
        this.tester.clickLink("show_" + id);
    }

    public void showFields(String name) {
        this.clickShowOrHide(name, "Show");
    }

    public void hideField(int id) {
        this.tester.clickLink("hide_" + id);
    }

    public void hideFields(String name) {
        this.clickShowOrHide(name, "Hide");
    }

    private void clickShowOrHide(String name, String urlText) {
        XPathLocator locator = new XPathLocator(this.tester, String.format("//table[@id = 'field_table']//a[contains(@title, \"'%s'\") and contains(text(), '%s')]/@id", name, urlText));
        Node[] nodes = locator.getNodes();
        if (nodes == null || nodes.length == 0) {
            throw new AssertionError((Object)String.format("Unable to %s field '%s': Could not find the '%s' link.", urlText, name, urlText));
        }
        for (Node node : nodes) {
            String id = node.getNodeValue();
            if (!StringUtils.isNotBlank((String)id)) continue;
            this.tester.clickLink(id);
        }
    }
}

