/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationSchemes;
import com.atlassian.jira.functest.framework.util.url.URLUtil;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebLink;
import net.sourceforge.jwebunit.WebTester;

public class FieldConfigurationSchemesImpl
extends AbstractFuncTestUtil
implements FieldConfigurationSchemes,
FieldConfigurationSchemes.FieldConfigurationScheme {
    private String fieldConfigurationSchemeId;
    private String fieldConfigurationSchemeName;

    public FieldConfigurationSchemesImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    protected Navigation getNavigation() {
        return this.getFuncTestHelperFactory().getNavigation();
    }

    protected Form getForm() {
        return this.getFuncTestHelperFactory().getForm();
    }

    public String addFieldConfigurationScheme(String name, String description) {
        this.getNavigation().gotoAdminSection("issue_fields");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("fieldLayoutSchemeName", name);
        if (description != null) {
            this.tester.setFormElement("fieldLayoutSchemeDescription", description);
        }
        this.tester.submit("Add");
        return this.getSchemeIdForName(name);
    }

    public FieldConfigurationSchemes.FieldConfigurationScheme fieldConfigurationScheme(String name) {
        this.getNavigation().gotoAdminSection("issue_fields");
        this.fieldConfigurationSchemeId = this.getSchemeIdForName(name);
        this.fieldConfigurationSchemeName = name;
        return this;
    }

    public void addAssociation(String issueTypeId, String fieldConfigurationName) {
        this.getNavigation().gotoAdminSection("issue_fields");
        this.getNavigation().clickLinkWithExactText(this.fieldConfigurationSchemeName);
        this.tester.setWorkingForm("jiraform");
        this.getForm().selectOptionsByValue("issueTypeId", new String[]{issueTypeId});
        this.tester.selectOption("fieldConfigurationId", fieldConfigurationName);
        this.tester.submit("Add");
        this.tester.assertLinkPresent("edit_fieldlayoutschemeentity_" + issueTypeId);
    }

    public void editAssociation(String issueTypeId, String newFieldConfigurationName) {
        this.getNavigation().gotoAdminSection("issue_fields");
        this.getNavigation().clickLinkWithExactText(this.fieldConfigurationSchemeName);
        String editLink = "edit_fieldlayoutschemeentity";
        if (issueTypeId != null) {
            editLink = editLink + "_" + issueTypeId;
        }
        this.tester.clickLink(editLink);
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("fieldConfigurationId", newFieldConfigurationName);
        this.tester.submit("Update");
    }

    public void removeAssociation(String issueTypeId) {
        this.getNavigation().gotoAdminSection("issue_fields");
        this.getNavigation().clickLinkWithExactText(this.fieldConfigurationSchemeName);
        this.tester.clickLink("delete_fieldlayoutschemeentity_" + issueTypeId);
        this.tester.assertLinkNotPresent("delete_fieldlayoutschemeentity_" + issueTypeId);
    }

    private String getSchemeIdForName(String fieldConfigSchemeName) {
        HtmlPage page = new HtmlPage(this.tester);
        WebLink schemeLink = page.getLinksWithExactText(fieldConfigSchemeName)[0];
        return URLUtil.getQueryParamValueFromUrl(schemeLink.getURLString(), "id");
    }
}

