/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.UserProfile;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class UserProfileImpl
extends AbstractFuncTestUtil
implements UserProfile {
    public UserProfileImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    public void changeUserNotificationType(boolean useHtml) {
        this.log("Changing user notification type to " + (useHtml ? "HTML" : "plain text"));
        this.gotoCurrentUserProfile();
        this.gotoEditUserPreferences();
        if (useHtml) {
            this.tester.selectOption("userNotificationsMimeType", "HTML");
        } else {
            this.tester.selectOption("userNotificationsMimeType", "Text");
        }
        this.tester.submit("Update");
    }

    public void changeUserSharingType(boolean global) {
        this.log("changing user sharing default to '" + (global ? "public" : "private") + "'.");
        this.gotoCurrentUserProfile();
        this.gotoEditUserPreferences();
        this.tester.setFormElement("shareDefault", String.valueOf(!global));
        this.tester.submit("Update");
    }

    public void changeDefaultSharingType(boolean global) {
        this.log("changing default user sharing to '" + (global ? "public" : "private") + "'.");
        this.gotoEditDefaultPerferences();
        this.tester.setFormElement("sharePublic", String.valueOf(!global));
        this.tester.submit("Update");
    }

    public void changeUserLanguage(String lang) {
        this.log("Changing user language to '" + lang + "'");
        this.gotoCurrentUserProfile();
        this.gotoEditUserPreferences();
        this.tester.selectOption("userLocale", lang);
        this.tester.submit();
    }

    private void gotoEditDefaultPerferences() {
        this.tester.gotoPage("secure/admin/jira/EditUserDefaultSettings!default.jspa");
    }

    private void gotoEditUserPreferences() {
        this.tester.clickLink("view_user_prefs");
        this.tester.clickLink("view_edit_prefs");
    }

    public void gotoCurrentUserProfile() {
        this.tester.clickLink("view_profile");
    }
}

