/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebClientListener;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class FuncTestWebClientListener
implements WebClientListener {
    private static final String REQUEST_START_TIME = "request.start.time";
    long requestCount = 0L;
    long requestTime = 0L;
    List<Long> requestTimeList = new ArrayList<Long>(100);

    public void requestSent(WebClient src, WebRequest req) {
        ++this.requestCount;
        src.setAttribute(REQUEST_START_TIME, (Object)new Date());
    }

    public void responseReceived(WebClient src, WebResponse resp) {
        Date then = (Date)src.getAttribute(REQUEST_START_TIME);
        if (then != null) {
            src.setAttribute(REQUEST_START_TIME, null);
            long timeMS = new Date().getTime() - then.getTime();
            this.requestTime += timeMS;
            this.requestTimeList.add(timeMS);
        }
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public long getPercentileRequestTime(int percentile) {
        if (this.requestTimeList.size() == 0) {
            return -1L;
        }
        Collections.sort(this.requestTimeList);
        if (percentile == 100) {
            return this.requestTimeList.get(this.requestTimeList.size() - 1);
        }
        int actualPercentile = Math.max(0, Math.min(100, percentile));
        int size = this.requestTimeList.size();
        double dPercentile = (double)size * (double)actualPercentile / 100.0;
        int index = Math.max(0, Math.min(size, (int)dPercentile));
        return this.requestTimeList.get(index);
    }
}

