/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Form;
import com.meterware.httpunit.WebForm;
import net.sourceforge.jwebunit.UnableToSetFormException;
import net.sourceforge.jwebunit.WebTester;
import org.xml.sax.SAXException;

public class FormImpl
implements Form {
    private WebTester webTester;

    public FormImpl(WebTester webTester) {
        this.webTester = webTester;
    }

    public void selectOption(String selectName, String option) {
        this.webTester.assertFormElementPresent(selectName);
        this.webTester.selectOption(selectName, option);
    }

    public void selectOptionsByDisplayName(String selectName, String[] options) {
        this.webTester.assertFormElementPresent(selectName);
        this.checkFormStateWithParameter(selectName);
        if (options.length > 0) {
            this.webTester.getDialog().getForm().setParameter(selectName, this.getValuesForOptions(selectName, options));
        } else {
            this.webTester.getDialog().getForm().removeParameter(selectName);
        }
    }

    public void selectOptionsByValue(String selectName, String[] options) {
        this.webTester.assertFormElementPresent(selectName);
        this.checkFormStateWithParameter(selectName);
        if (options.length > 0) {
            this.webTester.getDialog().getForm().setParameter(selectName, options);
        } else {
            this.webTester.getDialog().getForm().removeParameter(selectName);
        }
    }

    private String[] getValuesForOptions(String selectName, String[] options) {
        String[] values = new String[options.length];
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            values[i] = this.webTester.getDialog().getValueForOption(selectName, option);
        }
        return values;
    }

    private void checkFormStateWithParameter(String paramName) {
        if (this.webTester.getDialog().getForm() == null) {
            try {
                this.webTester.getDialog().setWorkingForm(this.getFormWithParameter(paramName).getID());
            }
            catch (UnableToSetFormException e) {
                throw new UnableToSetFormException("Unable to set form based on parameter [" + paramName + "].");
            }
        }
    }

    private WebForm getFormWithParameter(String paramName) {
        for (int i = 0; i < this.getForms().length; ++i) {
            String[] names;
            WebForm webForm = this.getForms()[i];
            for (String name : names = webForm.getParameterNames()) {
                if (!name.equals(paramName)) continue;
                return webForm;
            }
        }
        return null;
    }

    public WebForm[] getForms() {
        try {
            return this.webTester.getDialog().getResponse().getForms();
        }
        catch (SAXException ex) {
            throw new RuntimeException("Unable to get forms from the WebResponse.", ex);
        }
    }
}

