/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.CustomFields;
import com.atlassian.jira.functest.framework.admin.CustomFieldsImpl;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationSchemes;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationSchemesImpl;
import com.atlassian.jira.functest.framework.admin.FieldConfigurations;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationsImpl;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.admin.GeneralConfigurationImpl;
import com.atlassian.jira.functest.framework.admin.IssueLinking;
import com.atlassian.jira.functest.framework.admin.IssueLinkingImpl;
import com.atlassian.jira.functest.framework.admin.PermissionSchemes;
import com.atlassian.jira.functest.framework.admin.PermissionSchemesImpl;
import com.atlassian.jira.functest.framework.admin.Project;
import com.atlassian.jira.functest.framework.admin.ProjectImpl;
import com.atlassian.jira.functest.framework.admin.Resolutions;
import com.atlassian.jira.functest.framework.admin.ResolutionsImpl;
import com.atlassian.jira.functest.framework.admin.Roles;
import com.atlassian.jira.functest.framework.admin.RolesImpl;
import com.atlassian.jira.functest.framework.admin.Subtasks;
import com.atlassian.jira.functest.framework.admin.SubtasksImpl;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.admin.TimeTrackingImpl;
import com.atlassian.jira.functest.framework.admin.UsersAndGroups;
import com.atlassian.jira.functest.framework.admin.UsersAndGroupsImpl;
import com.atlassian.jira.functest.framework.admin.ViewServices;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.log.FuncTestLogger;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebTable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import net.sourceforge.jwebunit.WebTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdministrationImpl
extends AbstractFuncTestUtil
implements Administration,
FuncTestLogger {
    private static final String PAGE_TIME_TRACKING = "/secure/admin/jira/TimeTrackingAdmin!default.jspa";
    private static final String PAGE_TRACKBACKS = "/secure/admin/jira/TrackbackAdmin!default.jspa";
    private final Navigation navigation;
    private final TextAssertions text;
    private final GeneralConfiguration generalConfiguration;
    private final Project project;
    private final UsersAndGroups usersAndGroups;
    private final Roles roles;
    private final CustomFields customFields;
    private final PermissionSchemes permissionSchemes;
    private final FieldConfigurations fieldConfigurations;
    private final FieldConfigurationSchemes fieldConfigurationSchemes;
    private final ResolutionsImpl resolutions;
    private final ViewServices viewServices;

    public AdministrationImpl(WebTester tester, JIRAEnvironmentData environmentData, Navigation navigation, Assertions assertions) {
        super(tester, environmentData, 2);
        this.navigation = navigation;
        this.text = assertions.getTextAssertions();
        this.generalConfiguration = new GeneralConfigurationImpl(tester, environmentData);
        this.project = new ProjectImpl(tester, environmentData, navigation, assertions);
        this.usersAndGroups = new UsersAndGroupsImpl(tester, environmentData, assertions.getTextAssertions(), 3);
        this.roles = new RolesImpl(tester, environmentData, 3);
        this.customFields = new CustomFieldsImpl(tester, environmentData, navigation, this.getFuncTestHelperFactory().getForm(), assertions);
        this.permissionSchemes = new PermissionSchemesImpl(tester, environmentData);
        this.fieldConfigurations = new FieldConfigurationsImpl(tester, environmentData);
        this.fieldConfigurationSchemes = new FieldConfigurationSchemesImpl(tester, environmentData);
        this.resolutions = new ResolutionsImpl(tester, environmentData);
        this.viewServices = new ViewServices(tester, navigation);
    }

    @Override
    public void reIndex() {
        this.tester.gotoPage("secure/admin/jira/IndexAdmin.jspa");
        this.tester.submit("Re-Index");
        this.waitForIndexCompletetion(1000L, 100);
    }

    @Override
    public void setProfiling(boolean on) {
    }

    @Override
    public void restoreBlankInstance() {
        this.restoreData("blankprojects.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreDataWithReplacedTokens(String originalXmlFileName, Map<String, String> replacements) throws IOException {
        String resource = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + originalXmlFileName;
        String xml = this.getFileAsString(resource);
        xml = this.replaceTokens(xml, replacements);
        File newData = null;
        try {
            newData = File.createTempFile(originalXmlFileName, ".xml");
            FileWriter of = new FileWriter(newData);
            of.write(xml);
            of.close();
            this.restoreData(newData.getParent(), newData.getName());
        }
        finally {
            if (newData != null && newData.exists()) assert (newData.delete());
        }
    }

    @Override
    public void restoreData(String fileName) {
        this.restoreData(this.environmentData.getXMLDataLocation().getAbsolutePath(), fileName);
    }

    @Override
    public void restoreData(String path, String fileName) {
        long then = System.currentTimeMillis();
        String filePath = path + "/" + fileName;
        this.log("Restoring data '" + filePath + "'");
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", filePath);
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        try {
            this.tester.assertTextPresent("Your project has been successfully imported");
        }
        catch (AssertionFailedError e) {
            this.assertCauseOfError("The xml data you are trying to import seems to be from a newer version of JIRA. This will not work.", filePath);
            this.assertCauseOfError("You must enter the location of an XML file.", filePath);
            this.assertCauseOfError("Could not find file at this location.", filePath);
            this.assertCauseOfError("Invalid license key specified.", filePath);
            this.assertCauseOfError("The current license is too old to install this version of JIRA", filePath);
            this.assertCauseOfError("Invalid license type for this version of JIRA. License should be of type Standard.", filePath);
            this.assertCauseOfError("Invalid license type for this version of JIRA. License should be of type Professional.", filePath);
            this.assertCauseOfError("Invalid license type for this version of JIRA. License should be of type Enterprise.", filePath);
            this.assertCauseOfError("You must specify an index for the restore process.", filePath);
            this.assertCauseOfError("Error parsing export file. Your export file is invalid.", filePath);
            throw new AssertionError((Object)("Failed to restore JIRA data from [" + filePath + "]. See logs for details."));
        }
        long now = System.currentTimeMillis();
        this.navigation.login("admin", "admin");
        this.log("Restored '" + fileName + "' in " + (now - then) + "ms");
        this.generalConfiguration.setBaseUrl(this.getEnvironmentData().getBaseUrl().toString());
        this.tester.beginAt("/");
    }

    @Override
    public void restoreI18nData(String fileName) {
        long then = System.currentTimeMillis();
        String filePath = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + fileName;
        this.log("Restoring data '" + filePath + "'");
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", filePath);
        this.tester.setFormElement("license", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        try {
            Assert.assertNotNull((Object)new XPathLocator(this.tester, "//*[@id=\"login\"]").getNode());
        }
        catch (AssertionFailedError e) {
            throw new AssertionError((Object)"Your project failed to import successfully. See logs for details");
        }
        long now = System.currentTimeMillis();
        this.navigation.login("admin", "admin");
        this.log("Restored '" + fileName + "' in " + (now - then) + "ms");
    }

    @Override
    public void restoreDataWithLicense(String fileName, String licenseKey) {
        long then = System.currentTimeMillis();
        String filePath = this.environmentData.getXMLDataLocation().getAbsolutePath() + "/" + fileName;
        this.log("Restoring data '" + filePath + "'");
        this.tester.gotoPage("secure/admin/XmlRestore!default.jspa");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", filePath);
        this.tester.setFormElement("license", licenseKey);
        this.tester.submit();
        this.tester.assertTextPresent("Your project has been successfully imported");
        long now = System.currentTimeMillis();
        this.navigation.login("admin", "admin");
        this.log("Restored '" + fileName + "' in " + (now - then) + "ms");
        this.generalConfiguration.setBaseUrl(this.getEnvironmentData().getBaseUrl().toString());
        this.tester.beginAt("/");
    }

    @Override
    public void exportDataToPath(String absolutePath) {
        this.log("Backing up data to '" + absolutePath + "'");
        this.tester.gotoPage("secure/admin/XmlBackup!default.jspa");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("filename", absolutePath);
        this.tester.submit();
        if (this.tester.getDialog().isTextInResponse("Please confirm whether you want to replace this file.")) {
            this.tester.setWorkingForm("jiraform");
            this.tester.submit();
        }
        this.tester.assertTextPresent("Data exported to");
    }

    @Override
    public void disableAttachments() {
        this.log("Disabling attachments.");
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("attachmentPathOption", "DISABLED");
        this.tester.checkCheckbox("thumbnailsEnabled", "false");
        this.tester.submit("Update");
    }

    @Override
    public void enableAttachments() {
        this.log("Enabling attachments with default path.");
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("attachmentPathOption", "DEFAULT");
        this.tester.submit("Update");
    }

    @Override
    public String getCurrentAttachmentPath() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("attachments");
        WebTable attachmentSettings = this.tester.getDialog().getWebTableBySummaryOrId("attachmentSettings");
        if ("Attachment Path".equals(attachmentSettings.getCellAsText(2, 0).trim())) {
            String attachmentPath = attachmentSettings.getCellAsText(2, 1).trim();
            if (attachmentPath.startsWith("Default Directory [")) {
                attachmentPath = attachmentPath.substring("Default Directory [".length(), attachmentPath.length() - 1);
            }
            return attachmentPath;
        }
        throw new RuntimeException("Error occured when trying to screen-scrape the attachment path. 'Attachment Path' not found where expected in the table.");
    }

    @Override
    public void activateSubTasks() {
        this.log("activating sub tasks");
        this.tester.gotoPage("/secure/admin/subtasks/ManageSubTasks.jspa");
        if (this.tester.getDialog().isLinkPresentWithText("Enable")) {
            this.tester.clickLinkWithText("Enable");
        } else {
            this.log("Subtasks already enabled");
        }
    }

    @Override
    public void addSubTaskType(String name) {
        this.activateSubTasks();
        this.tester.setFormElement("name", name);
        this.tester.submit("Add");
    }

    @Override
    public void activateTimeTracking() {
        this.log("activating time tracking");
        this.submitAtPage(PAGE_TIME_TRACKING, "Activate", "time tracking already activated");
    }

    @Override
    public void deactivateTimeTracking() {
        this.log("deactivating time tracking");
        this.submitAtPage(PAGE_TIME_TRACKING, "Deactivate", "time tracking already deactivated");
    }

    @Override
    public void enableTrackBacks() {
        this.tester.gotoPage(PAGE_TRACKBACKS);
        this.tester.checkCheckbox("acceptPings", "true");
        this.tester.checkCheckbox("sendPings", "allIssues");
        this.tester.submit("Update");
    }

    @Override
    public GeneralConfiguration generalConfiguration() {
        return this.generalConfiguration;
    }

    @Override
    public Project project() {
        return this.project;
    }

    @Override
    public UsersAndGroups usersAndGroups() {
        return this.usersAndGroups;
    }

    @Override
    public Roles roles() {
        return this.roles;
    }

    @Override
    public CustomFields customFields() {
        return this.customFields;
    }

    @Override
    public PermissionSchemes permissionSchemes() {
        return this.permissionSchemes;
    }

    @Override
    public FieldConfigurations fieldConfigurations() {
        return this.fieldConfigurations;
    }

    @Override
    public FieldConfigurationSchemes fieldConfigurationSchemes() {
        return this.fieldConfigurationSchemes;
    }

    @Override
    public void disablePlugin(String pluginName, String pluginDescription) {
        this.log("disabling plugin: " + pluginName);
        this.navigation.gotoAdminSection("plugins");
        this.tester.clickLinkWithText(pluginName);
        this.tester.assertTextPresent(pluginDescription);
        if (this.tester.getDialog().isLinkPresentWithText("Disable plugin")) {
            this.tester.clickLinkWithText("Disable plugin");
            this.log("plugin disabled");
        } else {
            this.log("plugin already disabled");
        }
    }

    @Override
    public void enablePlugin(String pluginName, String pluginDescription) {
        this.log("enabling plugin: " + pluginName);
        this.navigation.gotoAdminSection("plugins");
        this.tester.clickLinkWithText(pluginName);
        this.tester.assertTextPresent(pluginDescription);
        if (this.tester.getDialog().isLinkPresentWithText("Enable plugin")) {
            this.tester.clickLinkWithText("Enable plugin");
            this.log("plugin enabled");
        } else {
            this.log("plugin already enabled");
        }
    }

    @Override
    public void disablePluginModule(String pluginName, String pluginDescription, String completeModuleKey) {
        String moduleLinkId = "disable-" + completeModuleKey;
        this.log("disabling module: " + completeModuleKey + " of plugin " + pluginName);
        this.navigation.gotoAdminSection("plugins");
        this.tester.clickLinkWithText(pluginName);
        this.tester.assertTextPresent(pluginDescription);
        this.tester.assertLinkPresentWithText("Disable plugin");
        if (this.tester.getDialog().isLinkPresent(moduleLinkId)) {
            this.tester.clickLink(moduleLinkId);
            this.log("module disabled");
        } else {
            this.log("module already disabled");
        }
    }

    @Override
    public void enablePluginModule(String pluginName, String pluginDescription, String completeModuleKey) {
        String moduleLinkId = "enable-" + completeModuleKey;
        this.log("enabling module: " + completeModuleKey + " of plugin " + pluginName);
        this.navigation.gotoAdminSection("plugins");
        this.tester.clickLinkWithText(pluginName);
        this.tester.assertTextPresent(pluginDescription);
        this.tester.assertLinkPresentWithText("Disable plugin");
        if (this.tester.getDialog().isLinkPresent(moduleLinkId)) {
            this.tester.clickLink(moduleLinkId);
            this.log("module enabled");
        } else {
            this.log("module already enabled");
        }
    }

    @Override
    public void removeGlobalPermission(int permission, String group) {
        this.tester.gotoPage("secure/admin/jira/GlobalPermissions.jspa?groupName=" + group + "&permType=" + permission + "&action=confirm");
        this.tester.assertTextPresent("Delete Global Permission");
        this.tester.submit("Delete");
    }

    @Override
    public void addGlobalPermission(int permission, String group) {
        this.tester.gotoPage("secure/admin/jira/GlobalPermissions.jspa?groupName=" + group + "&permType=" + permission + "&action=add");
    }

    @Override
    public void switchToLicense(LicenseKeys.License license) {
        this.switchToLicense(license.getLicenseString(), license.getDescription());
    }

    @Override
    public void switchToLicense(String license, String description) {
        this.navigation.gotoAdmin();
        this.tester.clickLink("license_details");
        this.tester.setFormElement("license", license);
        this.tester.submit("Add");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//table[@id='license_table']"), description);
    }

    @Override
    public void switchToPersonalLicense() {
        this.switchToLicense(LicenseKeys.V2_PERSONAL.getLicenseString(), "JIRA " + this.getEdition() + ": Personal");
    }

    @Override
    public void switchToStarterLicense() {
        this.switchToLicense(LicenseKeys.V2_STARTER.getLicenseString(), "JIRA " + this.getEdition() + ": Starter");
    }

    private void assertCauseOfError(String errorMessage, String filePath) {
        if (this.tester.getDialog().isTextInResponse(errorMessage)) {
            throw new AssertionError((Object)("Failed to restore JIRA data. Cause: " + errorMessage + " File path: [" + filePath + "]"));
        }
    }

    @Override
    public Subtasks subtasks() {
        return new SubtasksImpl(this.tester, this.getEnvironmentData());
    }

    @Override
    public IssueLinking issueLinking() {
        return new IssueLinkingImpl(this.tester, this.getEnvironmentData());
    }

    @Override
    public TimeTracking timeTracking() {
        return new TimeTrackingImpl(this.tester, this.getEnvironmentData());
    }

    @Override
    public Resolutions resolutions() {
        return this.resolutions;
    }

    @Override
    public ViewServices viewServices() {
        return this.viewServices;
    }

    @Override
    public String getEdition() {
        return "Enterprise";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileAsString(String path) throws IOException {
        File data = new File(path);
        FileReader fileReader = null;
        char[] buff = null;
        try {
            fileReader = new FileReader(data);
            int length = (int)data.length();
            buff = new char[length];
            fileReader.read(buff);
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
        return new String(buff);
    }

    private String replaceTokens(String source, Map<String, String> replacements) {
        for (String token : replacements.keySet()) {
            int index = source.indexOf(token);
            if (index < 0) {
                Assert.fail((String)("Replacement token '" + token + "' not found"));
            }
            source = source.replaceAll(token, replacements.get(token));
        }
        return source;
    }

    @Override
    public void runJellyScript(String script) {
        this.log("Running jelly script '" + script + "'.");
        this.navigation.gotoAdminSection("jelly_runner");
        this.tester.setFormElement("script", script);
        this.tester.submit("Run now");
    }

    @Override
    public void enableAccessLogging() {
        this.log("enabling access logging");
        this.navigation.gotoAdminSection("logging_profiling");
        this.tester.clickLink("enable_http_access");
    }

    @Override
    public Administration.Utilities utilities() {
        return new Util();
    }

    private void waitForIndexCompletetion(long sleepTime, int retryCount) {
        for (int i = 0; i < retryCount; ++i) {
            if (this.tester.getDialog().hasSubmitButton("Refresh")) {
                this.tester.submit("Refresh");
            } else {
                if (this.tester.getDialog().hasSubmitButton("Acknowledge")) {
                    this.tester.submit("Acknowledge");
                    return;
                }
                Assert.fail((String)"Unexpected button on progress screen.");
            }
            try {
                Thread.sleep(sleepTime);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Assert.fail((String)("Index operation did not complete after " + (double)(sleepTime * (long)retryCount) / 1000.0 + " sec."));
    }

    private class Util
    implements Administration.Utilities {
        private Util() {
        }

        public void runServiceNow(long serviceId) {
            AdministrationImpl.this.navigation.gotoPage("ServiceExecutor.jspa");
            AdministrationImpl.this.tester.setFormElement("serviceId", String.valueOf(serviceId));
            AdministrationImpl.this.tester.submit();
            AdministrationImpl.this.tester.assertTextNotPresent("No service with this id exists");
        }
    }
}

