/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.lucene.parsing;

import com.atlassian.jira.issue.index.JiraAnalyzer;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.atlassian.query.lucene.parsing.LuceneQueryParserFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.CharStream;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserTokenManager;
import org.apache.lucene.search.Query;

public class DefaultLuceneQueryParserFactory
implements LuceneQueryParserFactory {
    public QueryParser createParserFor(String fieldName) {
        return new LuceneQueryParser(fieldName, JiraAnalyzer.ANALYZER_FOR_SEARCHING);
    }

    static class LuceneQueryParser
    extends QueryParser {
        public LuceneQueryParser(String fieldName, Analyzer analyzer) {
            super(fieldName, analyzer);
        }

        protected LuceneQueryParser(CharStream stream) {
            super(stream);
        }

        protected LuceneQueryParser(QueryParserTokenManager tm) {
            super(tm);
        }

        protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
            if (quoted) {
                return this.newFieldQuery(JiraAnalyzer.ANALYZER_FOR_EXACT_SEARCHING, PhraseQuerySupportField.forIndexField((String)field), queryText, quoted);
            }
            return super.getFieldQuery(field, queryText, quoted);
        }
    }
}

