/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit.utilities;

import com.atlassian.jira.workflow.edit.TransitionData;
import com.atlassian.jira.workflow.edit.layout.display.TransitionOption;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ActionDescriptorTransitionData
implements TransitionData {
    private final ActionDescriptor actionDescriptor;
    private final boolean initial;
    private final boolean global;
    private final boolean looped;
    private final List<TransitionOption> transitionOptions;
    private final String screenName;
    private boolean showAdminData;

    public ActionDescriptorTransitionData(ActionDescriptor actionDescriptor, boolean initial, boolean global, boolean looped, List<TransitionOption> transitionOptions, @Nullable String screenName) {
        this(actionDescriptor, initial, global, looped, transitionOptions, true, screenName);
    }

    public ActionDescriptorTransitionData(ActionDescriptor actionDescriptor, boolean initial, boolean global, boolean looped, List<TransitionOption> transitionOptions, boolean showAdminData, @Nullable String screenName) {
        this.actionDescriptor = actionDescriptor;
        this.initial = initial;
        this.global = global;
        this.looped = looped;
        this.transitionOptions = transitionOptions;
        this.showAdminData = showAdminData;
        this.screenName = screenName;
    }

    @Override
    public int getActionId() {
        return this.actionDescriptor.getId();
    }

    @Override
    public String getName() {
        return this.actionDescriptor.getName();
    }

    @Override
    public String getDescription() {
        return (String)this.actionDescriptor.getMetaAttributes().get("jira.description");
    }

    @Override
    public Long getScreenId() {
        if (!this.showAdminData) {
            return null;
        }
        String screenId = (String)this.actionDescriptor.getMetaAttributes().get("jira.fieldscreen.id");
        return StringUtils.isBlank((CharSequence)screenId) ? null : Long.valueOf(screenId);
    }

    @Override
    public String getScreenName() {
        return this.screenName;
    }

    @Override
    public boolean isInitial() {
        return this.initial;
    }

    @Override
    public boolean isGlobal() {
        return this.global;
    }

    @Override
    public boolean isLooped() {
        return this.looped;
    }

    @Override
    public List<TransitionOption> getTransitionOptions() {
        if (!this.showAdminData) {
            return Collections.emptyList();
        }
        return this.transitionOptions;
    }
}

