/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.edit.Workflow;
import com.atlassian.jira.workflow.edit.WorkflowStatuses;
import com.atlassian.jira.workflow.edit.WorkflowStatusesValidator;
import com.atlassian.jira.workflow.edit.Workflows;
import com.atlassian.jira.workflow.edit.utilities.OutcomeHelper;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class WorkflowStatusesImpl
implements WorkflowStatuses {
    private final JiraAuthenticationContext authenticationContext;
    private final ConstantsService constantsService;
    private final StatusService statusService;
    private final Workflows workflows;
    private final StatusManager statusManager;
    private final WorkflowService workflowService;
    private final OutcomeHelper outcomeHelper;
    private final WorkflowStatusesValidator workflowStatusesValidator;

    public WorkflowStatusesImpl(JiraAuthenticationContext authenticationContext, ConstantsService constantsService, StatusService statusService, Workflows workflows, StatusManager statusManager, WorkflowService workflowService, OutcomeHelper outcomeHelper, WorkflowStatusesValidator workflowStatusesValidator) {
        this.authenticationContext = authenticationContext;
        this.constantsService = constantsService;
        this.statusService = statusService;
        this.workflows = workflows;
        this.statusManager = statusManager;
        this.workflowService = workflowService;
        this.outcomeHelper = outcomeHelper;
        this.workflowStatusesValidator = workflowStatusesValidator;
    }

    @Override
    public ServiceOutcome<Workflow> createAndAddStatusToWorkflow(boolean createGlobalTransition, String description, String name, String statusCategoryId, String workflowName) {
        ServiceOutcome<StatusCategory> statusCategoryOutcome = this.getStatusCategory(statusCategoryId);
        if (!statusCategoryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(statusCategoryOutcome);
        }
        ServiceOutcome createStatusOutcome = this.statusService.createStatus(this.authenticationContext.getLoggedInUser(), name, description, "/images/icons/statuses/generic.png", (StatusCategory)statusCategoryOutcome.getReturnedValue());
        if (!createStatusOutcome.isValid()) {
            return ServiceOutcomeImpl.error(createStatusOutcome);
        }
        Status status = (Status)createStatusOutcome.getReturnedValue();
        ServiceOutcome<Workflow> addStatusOutcome = createGlobalTransition ? this.addStatusAndGlobalTransitionToWorkflow(status, workflowName) : this.addStatusToWorkflow(status, workflowName);
        if (!addStatusOutcome.isValid()) {
            ServiceResult removeStatusErrors = this.statusService.removeStatus(this.authenticationContext.getLoggedInUser(), status);
            if (!removeStatusErrors.isValid()) {
                return this.outcomeHelper.errorOutcome(removeStatusErrors.getErrorCollection());
            }
            return this.outcomeHelper.errorOutcome(addStatusOutcome);
        }
        return addStatusOutcome;
    }

    @Override
    public ServiceOutcome<Workflow> addStatusAndGlobalTransitionToWorkflow(Status status, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyStatusCanBeAdded(status, workflowName);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> addStatusOutcome = workflow.addStatus(status);
        if (!addStatusOutcome.isValid()) {
            return addStatusOutcome;
        }
        ServiceOutcome<Workflow> addGlobalTransitionOutcome = workflow.addGlobalTransition(Workflow.AddTransitionParameters.builder().name(status.getName()).targetStatus(status).build());
        if (!addGlobalTransitionOutcome.isValid()) {
            return addGlobalTransitionOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    @Override
    public ServiceOutcome<Workflow> addStatusToWorkflow(Status status, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyStatusCanBeAdded(status, workflowName);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> addStatusOutcome = workflow.addStatus(status);
        if (!addStatusOutcome.isValid()) {
            return addStatusOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    @Override
    public ServiceOutcome<Workflow> removeStatus(String statusId, String workflowName) {
        ServiceOutcome<Pair<Workflow, Status>> verificationResult = this.verifyStatusCanBeRemoved(statusId, workflowName);
        if (!verificationResult.isValid()) {
            return ServiceOutcomeImpl.from(verificationResult.getErrorCollection());
        }
        Workflow workflow = (Workflow)((Pair)verificationResult.getReturnedValue()).first();
        ServiceOutcome<Workflow> removeStatusOutcome = workflow.removeStatus(statusId);
        if (!removeStatusOutcome.isValid()) {
            return removeStatusOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    @Override
    public ServiceOutcome<Workflow> updateStatus(String description, String name, String statusCategoryId, String statusId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyStatusCanBeUpdated(name, statusCategoryId, statusId, workflowName);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        ServiceOutcome<StatusCategory> statusCategoryOutcome = this.getStatusCategory(statusCategoryId);
        if (!statusCategoryOutcome.isValid()) {
            return this.outcomeHelper.errorOutcome(statusCategoryOutcome);
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> updateStatusOutcome = workflow.updateStatus(statusId, name);
        if (!updateStatusOutcome.isValid()) {
            return updateStatusOutcome;
        }
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        Status status = this.statusService.getStatusById(user, statusId);
        String originalStatusName = status.getName();
        ServiceOutcome editStatusOutcome = this.statusService.editStatus(user, status, name, description, status.getIconUrl(), (StatusCategory)statusCategoryOutcome.getReturnedValue());
        if (!editStatusOutcome.isValid()) {
            ServiceOutcome<Workflow> revertStatusOutcome = workflow.updateStatus(statusId, originalStatusName);
            if (!revertStatusOutcome.isValid()) {
                return this.outcomeHelper.errorOutcome(revertStatusOutcome);
            }
            return ServiceOutcomeImpl.error(editStatusOutcome);
        }
        return this.workflows.saveWorkflow(workflow);
    }

    private ServiceOutcome<StatusCategory> getStatusCategory(String id) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (id == null) {
            return this.constantsService.getDefaultStatusCategory(user);
        }
        return this.constantsService.getStatusCategoryById(user, id);
    }

    private ServiceOutcome<Workflow> verifyStatusCanBeAdded(Status status, String workflowName) {
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return workflowOutcome;
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (workflow.workflowContainsStepWithStatusId(status.getId())) {
            return this.outcomeHelper.errorOutcome("workflow.edit.status.exists", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(workflow);
    }

    @Override
    public ServiceOutcome<Pair<Workflow, Status>> verifyStatusCanBeRemoved(String statusId, String workflowName) {
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return ServiceOutcomeImpl.from(workflowOutcome.getErrorCollection());
        }
        ServiceResult validationResult = this.workflowStatusesValidator.validateStatusDelete(this.authenticationContext.getLoggedInUser(), (JiraWorkflow)workflowOutcome.get(), statusId);
        if (!validationResult.isValid()) {
            return this.outcomeHelper.errorOutcome(validationResult.getErrorCollection());
        }
        return this.outcomeHelper.okOutcome(Pair.nicePairOf((Object)workflowOutcome.get(), (Object)this.statusService.getStatusById(this.authenticationContext.getLoggedInUser(), statusId)));
    }

    @Override
    public ServiceOutcome<Pair<Workflow, Status>> verifyStatusCanBeRemoved(@NotNull Status status, String workflowName) {
        return this.verifyStatusCanBeRemoved(status.getId(), workflowName);
    }

    private ServiceOutcome<Workflow> verifyStatusCanBeUpdated(String name, String statusCategoryId, String statusId, String workflowName) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.enter.a.name", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)statusCategoryId)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.please.select.a.status.category", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return workflowOutcome;
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.workflowContainsStepWithStatusId(statusId)) {
            return this.outcomeHelper.errorOutcome("workflow.edit.status.not.found", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(workflow);
    }

    @Override
    public ServiceOutcome<Status> getStatus(String statusId, String workflowName) {
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!this.workflowService.isWorkflowEditable(this.authenticationContext.getLoggedInUser(), (JiraWorkflow)workflowOutcome.get())) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        Status status = this.statusManager.getStatus(statusId);
        if (status == null) {
            return this.outcomeHelper.errorOutcome("workflow.edit.status.not.found", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(status);
    }

    @Override
    public ServiceOutcome<Collection<Status>> getStatuses(String workflowName) {
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!this.workflowService.isWorkflowEditable(this.authenticationContext.getLoggedInUser(), (JiraWorkflow)workflowOutcome.get())) {
            return this.outcomeHelper.errorOutcome("workflow.edit.forbidden", new Object[0]);
        }
        return this.outcomeHelper.okOutcome(this.statusManager.getStatuses());
    }
}

