/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultProjectWorkflowSchemeHelper
implements ProjectWorkflowSchemeHelper {
    private final ProjectService projectService;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectManager projectManager;

    public DefaultProjectWorkflowSchemeHelper(ProjectService projectService, WorkflowSchemeManager workflowSchemeManager, JiraAuthenticationContext authenticationContext, ProjectManager projectManager) {
        this.projectService = projectService;
        this.workflowSchemeManager = workflowSchemeManager;
        this.authenticationContext = authenticationContext;
        this.projectManager = projectManager;
    }

    public List<Project> getAllProjectsForScheme(Long schemeId) {
        return this.getAllProjects().stream().filter(project -> Objects.equals(this.getSchemeIdForProject((Project)project), schemeId)).collect(Collectors.toList());
    }

    public List<Project> getProjectsForWorkflow(String workflowName) {
        Multimap<String, Project> workflow = this.getProjectsForWorkflow(Collections.singleton(workflowName));
        return Lists.newArrayList((Iterable)workflow.get((Object)workflowName));
    }

    public List<Project> getAllProjectsForWorkflow(String workflowName) {
        Multimap<String, Project> result = this.getAllProjectsForWorkflow(Collections.singleton(workflowName));
        return Lists.newArrayList((Iterable)result.get((Object)workflowName));
    }

    public Multimap<String, Project> getProjectsForWorkflow(Set<String> workflows) {
        List<Project> projects = this.getEditableProjects();
        return this.getProjectsUsingWorkflows(workflows, projects);
    }

    public Multimap<String, Project> getAllProjectsForWorkflow(Set<String> workflows) {
        return this.getProjectsUsingWorkflows(workflows, this.getAllProjects());
    }

    public boolean isWorkflowIsolated(String workflowName) {
        return this.getAllProjectsForWorkflow(workflowName).size() == 1;
    }

    private Multimap<String, Project> getProjectsUsingWorkflows(Set<String> workflows, List<Project> browsedProjects) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Project project : browsedProjects) {
            Map workflowMap = this.workflowSchemeManager.getWorkflowMap(project);
            String defaultWorkflow = workflowMap.get(null) != null ? (String)workflowMap.get(null) : "jira";
            Stream<String> issueTypesStream = project.getIssueTypes().stream().map(IssueConstant::getId);
            Stream<String> allIssueTypesStream = Stream.concat(issueTypesStream, Stream.of((String)null));
            Map<String, Project> workflowsMap = allIssueTypesStream.map(workflowMap::get).map(workflow -> workflow == null ? defaultWorkflow : workflow).filter(workflows::contains).collect(Collectors.toMap(wflow -> wflow, wflow -> project, (u, v) -> v));
            result.putAll((Multimap)Multimaps.forMap(workflowsMap));
        }
        return result;
    }

    private List<Project> getEditableProjects() {
        ServiceOutcome projectsForAction = this.projectService.getAllProjectsForAction(this.authenticationContext.getUser(), ProjectAction.VIEW_PROJECT_CONFIG);
        if (projectsForAction.isValid()) {
            return (List)projectsForAction.getReturnedValue();
        }
        return Collections.emptyList();
    }

    private Long getSchemeIdForProject(Project project) {
        try {
            GenericValue workflowScheme = this.workflowSchemeManager.getWorkflowScheme(project.getGenericValue());
            if (workflowScheme == null) {
                return null;
            }
            return workflowScheme.getLong("id");
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private List<Project> getAllProjects() {
        return Stream.concat(this.projectManager.getProjectObjects().stream(), this.projectManager.getArchivedProjects().stream()).collect(Collectors.toList());
    }
}

