/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueConstantImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflowComparator;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJiraWorkflow
implements JiraWorkflow {
    private static final Logger log = LoggerFactory.getLogger(AbstractJiraWorkflow.class);
    WorkflowDescriptor descriptor;
    protected final WorkflowManager workflowManager;
    private Multimap<FieldScreen, ActionDescriptor> fieldScreenActions = null;

    protected AbstractJiraWorkflow(WorkflowManager workflowManager, WorkflowDescriptor workflowDescriptor) {
        this.workflowManager = workflowManager;
        this.descriptor = workflowDescriptor;
    }

    public abstract String getName();

    public String getDescription() {
        return (String)this.descriptor.getMetaAttributes().get("jira.description");
    }

    public String getDisplayName() {
        return this.getName();
    }

    public WorkflowDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Collection<ActionDescriptor> getAllActions() {
        return this.getAllActionsMap().values();
    }

    public Collection<ActionDescriptor> getActionsByName(final String name) {
        return Sets.filter((Set)Sets.newHashSet(this.getAllActions()), (Predicate)new Predicate<ActionDescriptor>(){

            public boolean apply(ActionDescriptor action) {
                return action.getName().compareToIgnoreCase(name) == 0;
            }
        });
    }

    public int getNextActionId() {
        int offset = 0;
        SortedMap<Integer, ActionDescriptor> allActionsMap = this.getAllActionsMap();
        if (!allActionsMap.isEmpty()) {
            offset = allActionsMap.lastKey();
        }
        return offset + 10;
    }

    private SortedMap<Integer, ActionDescriptor> getAllActionsMap() {
        TreeMap<Integer, ActionDescriptor> actions = new TreeMap<Integer, ActionDescriptor>();
        this.addActionsToMap(actions, this.descriptor.getInitialActions());
        this.addActionsToMap(actions, this.descriptor.getGlobalActions());
        actions.putAll(this.descriptor.getCommonActions());
        List steps = this.descriptor.getSteps();
        for (Object step : steps) {
            StepDescriptor stepDescriptor = (StepDescriptor)step;
            for (Object o : stepDescriptor.getActions()) {
                ActionDescriptor actionDescriptor = (ActionDescriptor)o;
                if (actions.containsKey(new Integer(actionDescriptor.getId()))) continue;
                actions.put(new Integer(actionDescriptor.getId()), actionDescriptor);
            }
        }
        return actions;
    }

    private void addActionsToMap(SortedMap<Integer, ActionDescriptor> actionMap, Collection<ActionDescriptor> actions) {
        for (ActionDescriptor actionDescriptor : actions) {
            actionMap.put(new Integer(actionDescriptor.getId()), actionDescriptor);
        }
    }

    public Collection<ActionDescriptor> getActionsWithResult(StepDescriptor stepDescriptor) {
        Collection<ActionDescriptor> actions = this.getAllActions();
        Iterator<ActionDescriptor> iterator = actions.iterator();
        block0: while (iterator.hasNext()) {
            ActionDescriptor actionDescriptor = iterator.next();
            for (Object o : actionDescriptor.getConditionalResults()) {
                ResultDescriptor resultDescriptor = (ResultDescriptor)o;
                if (resultDescriptor.getStep() != stepDescriptor.getId()) continue;
                continue block0;
            }
            if (actionDescriptor.getUnconditionalResult().getStep() == stepDescriptor.getId()) continue;
            iterator.remove();
        }
        return actions;
    }

    public Collection getStepsWithAction(StepDescriptor stepDescriptor) {
        Collection<ActionDescriptor> actions = this.getAllActions();
        Iterator<ActionDescriptor> iterator = actions.iterator();
        block0: while (iterator.hasNext()) {
            ActionDescriptor actionDescriptor = iterator.next();
            for (Object o : actionDescriptor.getConditionalResults()) {
                ResultDescriptor resultDescriptor = (ResultDescriptor)o;
                if (resultDescriptor.getStep() != stepDescriptor.getId()) continue;
                continue block0;
            }
            if (actionDescriptor.getUnconditionalResult().getStep() == stepDescriptor.getId()) continue;
            iterator.remove();
        }
        return actions;
    }

    public boolean removeStep(StepDescriptor stepDescriptor) {
        if (!this.getActionsWithResult(stepDescriptor).isEmpty()) {
            throw new IllegalArgumentException("Cannot remove step - it is a destination step of at least one transition.");
        }
        return this.descriptor.getSteps().remove(stepDescriptor);
    }

    public StepDescriptor getLinkedStep(GenericValue status) {
        if (status == null) {
            throw new IllegalArgumentException();
        }
        return this.getLinkedStep(status.getString("id"));
    }

    public StepDescriptor getLinkedStep(Status status) {
        if (status == null) {
            throw new IllegalArgumentException();
        }
        return this.getLinkedStep(status.getId());
    }

    private StepDescriptor getLinkedStep(String statusId) {
        if (statusId == null) {
            throw new IllegalArgumentException();
        }
        for (Object o : this.descriptor.getSteps()) {
            StepDescriptor stepDescriptor = (StepDescriptor)o;
            if (!statusId.equals(stepDescriptor.getMetaAttributes().get("jira.status.id"))) continue;
            return stepDescriptor;
        }
        return null;
    }

    public Status getLinkedStatus(StepDescriptor stepDescriptor) {
        String linkedStatusId = this.getLinkedStatusId(stepDescriptor);
        Status linkedStatus = ComponentAccessor.getConstantsManager().getStatus(linkedStatusId);
        if (linkedStatus == null) {
            log.warn("Workflow '{}' contains step '{}' (ID:{}) which is linked to non-existing status (ID:{})", new Object[]{this.getName(), stepDescriptor.getName(), stepDescriptor.getId(), linkedStatusId});
        }
        return linkedStatus;
    }

    public Status getLinkedStatusObject(StepDescriptor stepDescriptor) {
        return this.getLinkedStatus(stepDescriptor);
    }

    public String getLinkedStatusId(StepDescriptor stepDescriptor) {
        if (stepDescriptor == null) {
            throw new IllegalArgumentException("Step cannot be null.");
        }
        if (stepDescriptor.getMetaAttributes() != null && stepDescriptor.getMetaAttributes().containsKey("jira.status.id")) {
            return (String)stepDescriptor.getMetaAttributes().get("jira.status.id");
        }
        throw new IllegalStateException("Step with id '" + stepDescriptor.getId() + "' does not have a valid linked status.");
    }

    public List<GenericValue> getLinkedStatuses() {
        return this.getLinkedStatusesStream().filter(Objects::nonNull).map(status -> ((IssueConstantImpl)((Object)status)).getGenericValue()).collect(Collectors.toList());
    }

    public List<Status> getLinkedStatusObjects() {
        return this.getLinkedStatusesStream().collect(Collectors.toList());
    }

    private Stream<Status> getLinkedStatusesStream() {
        List steps = this.descriptor.getSteps();
        return steps.stream().map(this::getLinkedStatus);
    }

    public Set<String> getLinkedStatusIds() {
        HashSet<String> ids = new HashSet<String>();
        for (Object o : this.descriptor.getSteps()) {
            StepDescriptor stepDescriptor = (StepDescriptor)o;
            ids.add(this.getLinkedStatusId(stepDescriptor));
        }
        return ImmutableSet.copyOf(ids);
    }

    public Collection getStepsForTransition(ActionDescriptor actionDescriptor) {
        if (this.isInitialAction(actionDescriptor)) {
            return Collections.emptyList();
        }
        if (this.isGlobalAction(actionDescriptor)) {
            return this.getDescriptor().getSteps();
        }
        if (this.isCommonAction(actionDescriptor)) {
            LinkedList<StepDescriptor> steps = new LinkedList<StepDescriptor>();
            for (Object o1 : this.descriptor.getSteps()) {
                StepDescriptor stepDescriptor = (StepDescriptor)o1;
                for (Object o : stepDescriptor.getCommonActions()) {
                    if (((Integer)o).intValue() != actionDescriptor.getId()) continue;
                    steps.add(stepDescriptor);
                }
            }
            return steps;
        }
        LinkedList<StepDescriptor> steps = new LinkedList<StepDescriptor>();
        for (Object o1 : this.descriptor.getSteps()) {
            StepDescriptor stepDescriptor = (StepDescriptor)o1;
            for (Object o : stepDescriptor.getActions()) {
                ActionDescriptor ad = (ActionDescriptor)o;
                if (ad.getId() != actionDescriptor.getId()) continue;
                steps.add(stepDescriptor);
                return steps;
            }
        }
        return Collections.emptyList();
    }

    public Collection<FunctionDescriptor> getPostFunctionsForTransition(ActionDescriptor actionDescriptor) {
        List conditionalResults;
        ArrayList allPostFunctions = Lists.newArrayList();
        if (actionDescriptor.getUnconditionalResult() != null && actionDescriptor.getUnconditionalResult().getPostFunctions() != null) {
            allPostFunctions.addAll(actionDescriptor.getUnconditionalResult().getPostFunctions());
        }
        if ((conditionalResults = actionDescriptor.getConditionalResults()) != null) {
            for (Object conditionalResult : conditionalResults) {
                ResultDescriptor resultDescriptor = (ResultDescriptor)conditionalResult;
                allPostFunctions.addAll(resultDescriptor.getPostFunctions());
            }
        }
        if (actionDescriptor.getPostFunctions() != null) {
            allPostFunctions.addAll(actionDescriptor.getPostFunctions());
        }
        return allPostFunctions;
    }

    public boolean isActive() throws WorkflowException {
        return this.workflowManager.isActive((JiraWorkflow)this);
    }

    public boolean isSystemWorkflow() throws WorkflowException {
        return this.workflowManager.isSystemWorkflow((JiraWorkflow)this);
    }

    public boolean isEditable() throws WorkflowException {
        return !this.isSystemWorkflow() && !this.isActive();
    }

    public boolean isDefault() {
        return "jira".equals(this.getName());
    }

    public boolean isInitialAction(ActionDescriptor actionDescriptor) {
        return this.getDescriptor().getInitialActions().contains(actionDescriptor);
    }

    public boolean isCommonAction(ActionDescriptor actionDescriptor) {
        return actionDescriptor.isCommon();
    }

    public boolean isGlobalAction(ActionDescriptor actionDescriptor) {
        return this.getDescriptor().getGlobalActions().contains(actionDescriptor);
    }

    public boolean isOrdinaryAction(ActionDescriptor actionDescriptor) {
        return !this.isInitialAction(actionDescriptor) && !this.isCommonAction(actionDescriptor) && !this.isGlobalAction(actionDescriptor);
    }

    public String getActionType(ActionDescriptor actionDescriptor) {
        if (actionDescriptor == null) {
            throw new IllegalArgumentException("ActionDescriptor cannot be null.");
        }
        if (this.isInitialAction(actionDescriptor)) {
            return "initial";
        }
        if (this.isGlobalAction(actionDescriptor)) {
            return "global";
        }
        if (this.isCommonAction(actionDescriptor)) {
            return "common";
        }
        if (this.isOrdinaryAction(actionDescriptor)) {
            return "ordinary";
        }
        throw new IllegalArgumentException("The action with id '" + actionDescriptor.getId() + "' is of unknown type.");
    }

    public void reset() {
        this.fieldScreenActions = null;
    }

    public Collection<ActionDescriptor> getActionsForScreen(FieldScreen fieldScreen) {
        if (this.fieldScreenActions == null) {
            this.fieldScreenActions = this.loadFieldScreenActions();
        }
        if (this.fieldScreenActions.containsKey((Object)fieldScreen)) {
            return this.fieldScreenActions.get((Object)fieldScreen);
        }
        return Collections.emptyList();
    }

    private Multimap<FieldScreen, ActionDescriptor> loadFieldScreenActions() {
        WorkflowActionsBean workflowActionsBean = new WorkflowActionsBean();
        HashMultimap map = HashMultimap.create();
        for (ActionDescriptor actionDescriptor : this.getAllActions()) {
            map.put((Object)workflowActionsBean.getFieldScreenForView(actionDescriptor), (Object)actionDescriptor);
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractJiraWorkflow)) {
            return false;
        }
        AbstractJiraWorkflow abstractJiraWorkflow = (AbstractJiraWorkflow)o;
        return this.getName().equals(abstractJiraWorkflow.getName());
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public int compareTo(JiraWorkflow o) {
        return JiraWorkflowComparator.COMPARATOR.compare(this, o);
    }

    public String getUpdateAuthorName() {
        ApplicationUser user = this.getUpdateAuthor();
        if (ComponentAccessor.getUserManager().isUserExisting(user)) {
            return user.getUsername();
        }
        return null;
    }

    public ApplicationUser getUpdateAuthor() {
        String updateAuthor = null;
        Map metaAttributes = this.descriptor.getMetaAttributes();
        if (metaAttributes != null) {
            updateAuthor = (String)metaAttributes.get("jira.update.author.key");
        }
        return ComponentAccessor.getUserManager().getUserByKeyEvenWhenUnknown(updateAuthor);
    }

    public Date getUpdatedDate() {
        String updateDateStr;
        Map metaAttributes = this.descriptor.getMetaAttributes();
        if (metaAttributes != null && (updateDateStr = (String)metaAttributes.get("jira.updated.date")) != null) {
            try {
                long timeInMillis = Long.parseLong(updateDateStr);
                return new Date(timeInMillis);
            }
            catch (NumberFormatException e) {
                log.error("The workflow '" + this.getName() + "' is storing a invalid updated date string '" + updateDateStr + "'.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasDraftWorkflow() {
        return this.workflowManager.getDraftWorkflow(this.getName()) != null;
    }

    public String getMode() {
        if (this.isDraftWorkflow()) {
            return "draft";
        }
        return "live";
    }
}

