/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.annotations.Internal;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.core.logging.ThreadLocalErrorCollection;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.EnumerationIterator;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtils;
import com.atlassian.jira.web.util.InternalServerErrorExceptionDataSource;
import com.atlassian.logging.log4j.StackTraceInfo;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

@Internal
public class InternalServerErrorDataSource {
    public static final String JAVAX_SERVLET_ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String JAVAX_SERVLET_ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String UNKNOWN = "Unknown";
    private final I18nHelper i18n;
    @Nullable
    private final ExtendedSystemInfoUtils extendedSystemInfoUtils;
    private final ServletContext servletContext;
    private final LocaleManager localeManager;
    private final HttpServletRequest request;

    public InternalServerErrorDataSource(I18nHelper i18n, ExtendedSystemInfoUtils extendedSystemInfoUtils, ServletContext servletContext, LocaleManager localeManager, HttpServletRequest req) {
        this.i18n = i18n;
        this.extendedSystemInfoUtils = extendedSystemInfoUtils;
        this.servletContext = servletContext;
        this.localeManager = localeManager;
        this.request = req;
    }

    public ImmutableMap.Builder<String, Object> appendFullMessageData(ImmutableMap.Builder<String, Object> map, boolean isSysadmin) {
        this.appendSimpleMessageData(map);
        map.put((Object)"serverInfo", this.soyMap(this.translateKeys(this.getServerInfo())));
        map.put((Object)"requestInfo", this.soyMap(this.translateKeys(this.getRequestInfo())));
        map.put((Object)"requestAttributes", this.soyMap(this.translateKeys(this.getRequestAttributes())));
        map.put((Object)"loggingEvents", InternalServerErrorDataSource.getLoggingEvents());
        if (this.extendedSystemInfoUtils != null) {
            if (isSysadmin) {
                map.put((Object)"filePaths", this.soyMap(this.translateKeys(this.getFilePaths())));
                map.put((Object)"sysInfo", this.soyMap(this.extendedSystemInfoUtils.getProps()));
            } else {
                Map<String, String> sysProps = this.extendedSystemInfoUtils.getProps();
                ImmutableSet sysadminOnlyProps = ImmutableSet.of((Object)this.i18n.getText("admin.systeminfo.system.cwd"), (Object)this.i18n.getText("admin.systeminfo.jvm.input.arguments"));
                map.put((Object)"sysInfo", this.soyMap(InternalServerErrorDataSource.filterKeys(sysProps, (Set<String>)sysadminOnlyProps, this.i18n.getText("system.error.property.not.sysadmin"))));
            }
            map.put((Object)"languageInfo", this.translateKeys(this.getLanguageInfo()));
            map.put((Object)"listeners", this.getListeners());
            map.put((Object)"services", this.getServices());
            map.put((Object)"buildInfoData", this.soyMap(this.extendedSystemInfoUtils.getBuildStats()));
            map.put((Object)"memInfo", this.soyMap(this.extendedSystemInfoUtils.getJvmStats()));
            map.put((Object)"plugins", this.getPlugins());
        }
        return map;
    }

    public void appendSimpleMessageData(ImmutableMap.Builder<String, Object> map) {
        map.put((Object)"generalInfo", this.getGeneralInfo());
    }

    public Map<String, Object> getGeneralInfo() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        InternalServerErrorExceptionDataSource exceptionInfo = new InternalServerErrorExceptionDataSource((Throwable)this.request.getAttribute(JAVAX_SERVLET_ERROR_EXCEPTION), this.extendedSystemInfoUtils);
        map.put((Object)"interpretedMsg", (Object)exceptionInfo.getInterpretedMessage());
        map.put((Object)"cause", (Object)exceptionInfo.getRootCause());
        map.put((Object)"stacktrace", (Object)exceptionInfo.getStacktrace());
        map.put((Object)"referer", (Object)(this.request.getHeader("Referer") != null ? this.request.getHeader("Referer") : UNKNOWN));
        map.put((Object)"servletErrorMessage", this.request.getAttribute(JAVAX_SERVLET_ERROR_MESSAGE) != null ? this.request.getAttribute(JAVAX_SERVLET_ERROR_MESSAGE) : "");
        return map.build();
    }

    private Map<String, Object> getLanguageInfo() {
        String defaultLang = this.extendedSystemInfoUtils.getDefaultLanguage();
        if (this.extendedSystemInfoUtils.isUsingSystemLocale()) {
            defaultLang = defaultLang + " - " + this.i18n.getText("admin.systeminfo.system.default.locale");
        }
        return ImmutableMap.of((Object)"admin.generalconfiguration.installed.languages", this.getInstalledLocales(), (Object)"admin.generalconfiguration.default.language", (Object)defaultLang);
    }

    private List<String> getInstalledLocales() {
        if (this.localeManager != null) {
            return (List)this.localeManager.getInstalledLocales().stream().map(locale -> locale.getDisplayName(this.i18n.getLocale())).collect(CollectorsUtil.toImmutableList());
        }
        return ImmutableList.of();
    }

    private Map<String, String> getServerInfo() {
        return ImmutableMap.of((Object)"system.error.application.server", (Object)this.servletContext.getServerInfo(), (Object)"system.error.servlet.version", (Object)(this.servletContext.getMajorVersion() + "." + this.servletContext.getMinorVersion()));
    }

    private Map<String, String> getFilePaths() {
        return ImmutableMap.of((Object)"system.error.location.of.log", (Object)this.extendedSystemInfoUtils.getLogPath(), (Object)"system.error.location.of.entityengine", (Object)this.extendedSystemInfoUtils.getEntityEngineXmlPath());
    }

    private Map<String, String> getRequestInfo() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)10);
        map.put("system.error.request.url", this.request.getRequestURL().toString());
        map.put("system.error.scheme", this.request.getScheme());
        map.put("system.error.server", this.request.getServerName());
        map.put("system.error.port", Integer.toString(this.request.getServerPort()));
        map.put("system.error.uri", this.request.getRequestURI());
        map.put("system.error.context.path", this.request.getContextPath());
        map.put("system.error.servlet.path", this.request.getServletPath());
        map.put("system.error.path.info", this.request.getPathInfo());
        map.put("system.error.query.string", this.request.getQueryString());
        return map;
    }

    private Map<String, String> getRequestAttributes() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        EnumerationIterator.fromEnumeration((Enumeration)this.request.getAttributeNames()).forEachRemaining(attr -> map.put(attr, (Object)String.valueOf(this.request.getAttribute(attr))));
        return map.build();
    }

    private static List<Map<String, Object>> getLoggingEvents() {
        List events = ThreadLocalErrorCollection.getList();
        return InternalServerErrorDataSource.convert(events, (datedLoggingEvent, map) -> {
            LoggingEvent event = datedLoggingEvent.getEvent();
            ThrowableInformation throwableInformation = event.getThrowableInformation();
            Throwable throwable = throwableInformation == null ? null : throwableInformation.getThrowable();
            map.put("loggerName", event.getLoggerName());
            map.put("level", event.getLevel());
            map.put("date", datedLoggingEvent.getDate().toString());
            map.put("message", event.getRenderedMessage());
            map.put("throwableStrRep", throwable != null ? StackTraceInfo.asLines((Throwable)throwable) : Collections.emptyList());
        });
    }

    private List<Map<String, Object>> getListeners() {
        return InternalServerErrorDataSource.convert(this.extendedSystemInfoUtils.getListeners(), (listener, map) -> {
            map.put("name", listener.getString("name"));
            map.put("clazz", listener.getString("clazz"));
            PropertySet propset = OFBizPropertyUtils.getPropertySet(listener);
            List<String> keys = propset.getKeys(5);
            if (keys == null) {
                keys = Collections.emptyList();
            }
            HashMap values = Maps.newHashMapWithExpectedSize((int)keys.size());
            for (String key : keys) {
                values.put(key, propset.getString(key));
            }
            map.put("properties", this.soyMap(values));
        });
    }

    private List<Map<String, Object>> getServices() {
        return InternalServerErrorDataSource.convert(this.extendedSystemInfoUtils.getServices(), (service, map) -> {
            map.put("name", service.getName());
            map.put("class", service.getServiceClass());
            map.put("schedule", service.getCronExpression());
            map.put("properties", this.soyMap(this.translateValues(this.extendedSystemInfoUtils.getServicePropertyMap((JiraServiceContainer)service))));
        });
    }

    private List<Map<String, Object>> getPlugins() {
        return InternalServerErrorDataSource.convert(this.extendedSystemInfoUtils.getPlugins(), (plugin, map) -> {
            PluginInformation info = plugin.getPluginInformation();
            map.put("name", plugin.getName());
            map.put("version", info.getVersion());
            map.put("vendor", info.getVendorName());
            map.put("enabled", this.extendedSystemInfoUtils.isPluginEnabled((Plugin)plugin));
            map.put("parameters", this.soyMap(info.getParameters()));
        });
    }

    private static Map<String, String> filterKeys(Map<String, String> sourceMap, Set<String> keysToRemove, String replacementValue) {
        if (replacementValue == null) {
            return Maps.filterKeys(sourceMap, input -> !keysToRemove.contains(input));
        }
        return Maps.transformEntries(sourceMap, (key, value) -> keysToRemove.contains(key) ? replacementValue : value);
    }

    private <T> Map<String, T> translateKeys(Map<String, T> sourceMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)sourceMap.size());
        sourceMap.forEach((key, value) -> resultMap.put(this.i18n.getText(key), value));
        return resultMap;
    }

    private Map<String, String> translateValues(Map<String, String> sourceMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)sourceMap.size());
        sourceMap.forEach((key, value) -> resultMap.put(key, this.i18n.getText(value)));
        return resultMap;
    }

    private <T> Object soyMap(Map<String, T> map) {
        return InternalServerErrorDataSource.listifyMap(map);
    }

    private static <T> List<Map<String, Object>> listifyMap(Map<String, T> map) {
        ImmutableList.Builder list = ImmutableList.builder();
        map.forEach((key, value) -> list.add((Object)FieldMap.build((String)"key", (Object)key, (String)"value", (Object)value)));
        return list.build();
    }

    private static <T> List<Map<String, Object>> convert(Iterable<T> objects, BiConsumer<T, Map<String, Object>> mapper) {
        if (objects == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        objects.forEach(obj -> {
            HashMap map = Maps.newHashMap();
            mapper.accept(obj, map);
            result.add((Object)map);
        });
        return result.build();
    }
}

