/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.startup;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.RedirectSanitiser;
import com.atlassian.jira.web.filters.johnson.JiraJohnsonFilter;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StartupPageSupport {
    @VisibleForTesting
    public static final String STARTUP_JSP = "/startup.jsp";
    private static final Logger LOG = LoggerFactory.getLogger(StartupPageSupport.class);
    private static final String RETURN_TO = "returnTo";
    private static final Map<Locale, Function<String, String>> TRANSLATIONS = new ConcurrentHashMap<Locale, Function<String, String>>(4);
    private static volatile boolean launched = false;

    public static boolean isLaunched() {
        return launched;
    }

    public static void setLaunched(boolean launched) {
        StartupPageSupport.launched = launched;
    }

    public static boolean isStartupPage(ServletRequest request) {
        return StartupPageSupport.isStartupPage((HttpServletRequest)request);
    }

    public static boolean isStartupPage(HttpServletRequest request) {
        return StartupPageSupport.isStartupPage(JiraJohnsonFilter.getServletPathFromRequest(request));
    }

    static boolean isStartupPage(String servletPath) {
        return STARTUP_JSP.equals(servletPath);
    }

    public static void redirectToStartupPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String contextPath = request.getContextPath();
        String servletPath = JiraJohnsonFilter.getServletPathFromRequest(request);
        if (StartupPageSupport.isStartupPage(servletPath)) {
            throw new IllegalStateException("Redirected to startup.jsp when already there?!");
        }
        LOG.debug("Redirecting request from '{}' to '{}'", (Object)servletPath, (Object)STARTUP_JSP);
        String url = StartupPageSupport.makeStartupPageUrl(contextPath, servletPath, request.getQueryString());
        response.sendRedirect(url);
    }

    private static String makeStartupPageUrl(String contextPath, String servletPath, String query) {
        String base = StringUtils.isBlank((CharSequence)contextPath) ? "/" : contextPath;
        UrlBuilder url = new UrlBuilder(base).addPaths(STARTUP_JSP);
        StringBuilder sb = new StringBuilder(64);
        if (StringUtils.isNotBlank((CharSequence)servletPath) && !StartupPageSupport.isStartupPage(servletPath)) {
            sb.append(servletPath);
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            sb.append('?').append(query);
        }
        if (sb.length() > 0) {
            url.addParameter(RETURN_TO, sb.toString());
        }
        return url.asUrlString();
    }

    public static void returnFromStartupJsp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(StartupPageSupport.sanitize(request.getContextPath(), request.getParameter(RETURN_TO)));
    }

    private static String sanitize(String contextPath, @Nullable String returnTo) {
        String home;
        String string = home = StringUtils.isBlank((CharSequence)contextPath) ? "/" : contextPath;
        if (StringUtils.isBlank((CharSequence)returnTo)) {
            return home;
        }
        return ComponentAccessor.getComponentSafely(RedirectSanitiser.class).map(rs -> rs.makeSafeRedirectUrl(contextPath + returnTo)).orElse(home);
    }

    public static Function<String, String> getTranslator(HttpServletRequest request) {
        return TRANSLATIONS.computeIfAbsent(request.getLocale(), StartupPageSupport::createTranslator);
    }

    private static Function<String, String> createTranslator(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(StartupPageSupport.class.getName(), locale, StartupPageSupport.class.getClassLoader());
            return msgKey -> {
                try {
                    return bundle.getString((String)msgKey);
                }
                catch (RuntimeException re) {
                    return msgKey;
                }
            };
        }
        catch (RuntimeException re) {
            LOG.debug("Unable to create a translator for locale {}", (Object)locale);
            return Function.identity();
        }
    }

    private StartupPageSupport() {
    }
}

