/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.filters.johnson.ServiceUnavailableResponder;
import com.atlassian.jira.web.servlet.AbstractAvatarServlet;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ViewUserAvatarServlet
extends AbstractAvatarServlet {
    @Override
    protected void defaultDoGet(HttpServletRequest request, HttpServletResponse response, String ownerId, Long avatarId, Avatar.Size size) throws IOException, ServletException {
        AvatarService avatarService = ComponentAccessor.getAvatarService();
        ApplicationUser avatarUser = this.getUserUtil().getUserByKey(ownerId);
        ApplicationUser remoteUser = this.getAuthenticationContext().getLoggedInUser();
        if (avatarUser != null && remoteUser != null && avatarService.isUsingExternalAvatar(remoteUser, avatarUser)) {
            this.redirectToExternalAvatar(response, ownerId, size);
            return;
        }
        super.defaultDoGet(request, response, ownerId, avatarId, size);
    }

    @Override
    protected Long validateInput(String ownerId, Long avatarId, HttpServletResponse response) throws IOException {
        Optional userPropertyManagerOptional = ComponentAccessor.getComponentSafely(UserPropertyManager.class);
        if (!userPropertyManagerOptional.isPresent()) {
            ServiceUnavailableResponder.respondWithEmpty503(response);
            return null;
        }
        Optional<AvatarManager> avatarManagerOptional = this.getAvatarManager();
        if (!avatarManagerOptional.isPresent()) {
            ServiceUnavailableResponder.respondWithEmpty503(response);
            return null;
        }
        if (StringUtils.isBlank((CharSequence)ownerId) && avatarId == null) {
            response.sendError(404, "No avatar requested");
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)ownerId)) {
            ApplicationUser user = this.getUserUtil().getUserByKey(ownerId);
            if (user == null || !avatarManagerOptional.get().hasPermissionToView(this.getAuthenticationContext().getUser(), user)) {
                return Long.parseLong(this.getApplicationProperties().getString("jira.avatar.user.anonymous.id"));
            }
            if (avatarId == null) {
                PropertySet userPropertySet = ((UserPropertyManager)userPropertyManagerOptional.get()).getPropertySet(user);
                avatarId = userPropertySet.exists("user.avatar.id") ? Long.valueOf(userPropertySet.getLong("user.avatar.id")) : Long.valueOf(Long.parseLong(this.getApplicationProperties().getString("jira.avatar.user.default.id")));
            }
        }
        return avatarId;
    }

    private void redirectToExternalAvatar(HttpServletResponse response, String ownerId, Avatar.Size size) throws IOException {
        Optional avatarServiceOptional = ComponentAccessor.getComponentSafely(AvatarService.class);
        if (!avatarServiceOptional.isPresent()) {
            response.sendError(404, "No AvatarService");
            return;
        }
        Optional<AvatarManager> avatarManagerOptional = this.getAvatarManager();
        if (!avatarManagerOptional.isPresent()) {
            response.sendError(404, "No AvatarManager");
            return;
        }
        if (!avatarManagerOptional.get().hasPermissionToView(this.getAuthenticationContext().getUser(), this.getUserUtil().getUserByKey(ownerId))) {
            response.sendError(404);
            return;
        }
        ApplicationUser loggedInUser = this.getAuthenticationContext().getUser();
        URI gravatarURL = ((AvatarService)avatarServiceOptional.get()).getAvatarURL(loggedInUser, this.getUserUtil().getUserByKey(ownerId), size);
        response.sendRedirect(gravatarURL.toString());
    }

    @Override
    protected String getOwnerId(HttpServletRequest request) {
        String ownerId = super.getOwnerId(request);
        if (StringUtils.isBlank((CharSequence)ownerId)) {
            String username = StringUtils.trim((String)request.getParameter("username"));
            ApplicationUser user = this.getUserUtil().getUserByName(username);
            if (user != null) {
                ownerId = user.getKey();
            }
        }
        return ownerId;
    }

    @Override
    protected String getOwnerIdParamName() {
        return "ownerId";
    }

    JiraAuthenticationContext getAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    UserUtil getUserUtil() {
        return ComponentAccessor.getUserUtil();
    }
}

