/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.landingpage;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.dmz.api.web.landingpage.LandingPageRegistrar;
import com.atlassian.jira.dmz.api.web.redirect.PageRedirect;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.landingpage.LandingPageRedirector;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;

@ParametersAreNonnullByDefault
@ThreadSafe
public class LandingPageRedirectManager
implements LandingPageRegistrar,
LandingPageRedirector {
    private static final PageRedirectComparator COMPARATOR = new PageRedirectComparator();
    private final AtomicReference<ImmutableSet<RedirectWithPriority>> redirectsRef = new AtomicReference<ImmutableSet>(ImmutableSet.of());
    private final FeatureManager featureManager;

    public LandingPageRedirectManager(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public void registerRedirect(PageRedirect redirect, int priority) {
        Assertions.notNull((String)"redirect", (Object)redirect);
        RedirectWithPriority redirectWithPriority = new RedirectWithPriority(redirect, priority);
        this.redirectsRef.getAndUpdate(redirects -> {
            if (redirects.contains((Object)redirectWithPriority)) {
                return redirects;
            }
            return this.addPageRedirect(redirectWithPriority, (ImmutableSet<RedirectWithPriority>)redirects);
        });
    }

    public boolean unregisterRedirect(PageRedirect redirectToRemove) {
        Assertions.notNull((String)"urlToRemove", (Object)redirectToRemove);
        RedirectWithPriority redirectWithPriority = new RedirectWithPriority(redirectToRemove, 0);
        ImmutableSet<RedirectWithPriority> previous = this.redirectsRef.getAndUpdate(redirects -> this.removeFromSet(redirectWithPriority, (ImmutableSet<RedirectWithPriority>)redirects));
        return previous.contains((Object)redirectWithPriority);
    }

    @Override
    public Optional<String> redirectUrl(@Nullable ApplicationUser applicationUser) {
        if (this.featureManager.isEnabled("jira.onboarding.feature.disabled")) {
            return Optional.empty();
        }
        return this.redirectsRef.get().stream().map(r -> r.url(applicationUser)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private ImmutableSet<RedirectWithPriority> addPageRedirect(RedirectWithPriority newElement, ImmutableSet<RedirectWithPriority> existingElements) {
        ArrayList<RedirectWithPriority> redirects = new ArrayList<RedirectWithPriority>(existingElements.size() + 1);
        redirects.addAll((Collection<RedirectWithPriority>)existingElements);
        redirects.add(newElement);
        redirects.sort(COMPARATOR);
        return ImmutableSet.copyOf(redirects);
    }

    private ImmutableSet<RedirectWithPriority> removeFromSet(RedirectWithPriority redirectToRemove, ImmutableSet<RedirectWithPriority> existingElements) {
        return (ImmutableSet)existingElements.stream().filter(existingElement -> !existingElement.equals(redirectToRemove)).collect(CollectorsUtil.toImmutableSet());
    }

    private static final class RedirectWithPriority
    implements PageRedirect {
        private final PageRedirect pageRedirect;
        private final int priority;

        public RedirectWithPriority(PageRedirect pageRedirect, int priority) {
            this.pageRedirect = pageRedirect;
            this.priority = priority;
        }

        public int priority() {
            return this.priority;
        }

        public Optional<String> url(ApplicationUser user) {
            return this.pageRedirect.url(user);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RedirectWithPriority that = (RedirectWithPriority)o;
            return Objects.equals(this.pageRedirect, that.pageRedirect);
        }

        public int hashCode() {
            return Objects.hash(this.pageRedirect);
        }
    }

    private static final class PageRedirectComparator
    implements Comparator<RedirectWithPriority> {
        private PageRedirectComparator() {
        }

        @Override
        public int compare(RedirectWithPriority redirect1, RedirectWithPriority redirect2) {
            return redirect1.priority() - redirect2.priority();
        }
    }
}

