/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.requestcleanup;

import com.atlassian.core.logging.ThreadLocalErrorCollection;
import com.atlassian.jira.cache.request.RequestCacheController;
import com.atlassian.jira.dashboard.permission.JiraPermissionService;
import com.atlassian.jira.issue.index.ThreadLocalSearcherCache;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterStep;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.ofbiz.core.entity.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCleanupStep
implements FilterStep {
    private static final Logger log = LoggerFactory.getLogger(RequestCleanupStep.class);

    @Override
    public FilterCallContext beforeDoFilter(FilterCallContext callContext) {
        ThreadLocalSearcherCache.startSearcherContext();
        JiraAuthenticationContextImpl.clearRequestCache();
        RequestCacheController.startContext();
        DefaultVelocityRequestContextFactory.cacheVelocityRequestContext(callContext.getHttpServletRequest());
        ThreadLocalErrorCollection.clear();
        return callContext;
    }

    @Override
    public FilterCallContext finallyAfterDoFilter(FilterCallContext callContext) {
        ThreadLocalErrorCollection.clear();
        JiraAuthenticationContextImpl.clearRequestCache();
        JiraPermissionService.setAllowEditingOfDefaultDashboard(true);
        try {
            boolean printRequestDetails = false;
            if (!ImportUtils.isIndexIssues()) {
                log.error("Indexing thread local not cleared. Clearing...");
                ImportUtils.setIndexIssues((boolean)true);
                printRequestDetails = true;
            }
            if (TransactionUtil.getLocalTransactionConnection() != null) {
                log.error("Connection not cleared from thread local.");
                TransactionUtil.closeAndClearThreadLocalConnection();
                printRequestDetails = true;
            }
            if (printRequestDetails) {
                HttpServletRequest httpServletRequest = callContext.getHttpServletRequest();
                log.error("The URL of request that did not clear connection is: " + httpServletRequest.getRequestURL());
                HttpSession session = httpServletRequest.getSession(false);
                if (session != null) {
                    log.error("The User of request was: " + session.getAttribute("seraph_defaultauthenticator_user"));
                } else {
                    log.error("No session found. Cannot determine user.");
                }
                log.error("Content type:" + httpServletRequest.getContentType());
                Map parameterMap = httpServletRequest.getParameterMap();
                if (parameterMap != null) {
                    int j = 1;
                    Iterator iterator = parameterMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = iterator.next();
                        log.error("Parameter " + j + " name: " + entry.getKey());
                        Object value = entry.getValue();
                        if (value != null && value instanceof String[]) {
                            String[] valueArray;
                            for (String s : valueArray = (String[])value) {
                                log.error("Parameter value: " + s);
                            }
                        } else {
                            log.error("Parameter value: " + value);
                        }
                        ++j;
                    }
                } else {
                    log.error("Request did not have any parameters.");
                }
            }
        }
        catch (Exception t) {
            log.error("Error while inspecting thread locals.", (Throwable)t);
        }
        RequestCacheController.closeContext();
        ThreadLocalSearcherCache.stopAndCloseSearcherContext();
        return callContext;
    }
}

