/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarTranscoder;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.web.filters.util.InMemoryServletResponseWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class SvgToPngTranscoderFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        Avatar.Size size = this.getSize(request);
        if (this.needsTranscoding(request)) {
            InMemoryServletResponseWrapper wrapper = new InMemoryServletResponseWrapper(response);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
            byte[] svgBytes = wrapper.getOutputStream().getStream().toByteArray();
            if (svgBytes.length == 0) {
                return;
            }
            ByteArrayInputStream svgInputStream = new ByteArrayInputStream(svgBytes);
            Optional<AvatarTranscoder> avatarTranscoder = this.getAvatarTranscoder();
            byte[] pngBytes = avatarTranscoder.orElseThrow(() -> new ServletException("AvatarTranscoder is not present")).transcodeAndTag(request.getServletPath(), svgInputStream, size);
            response.setContentLength(pngBytes.length);
            response.setContentType("image/png");
            response.getOutputStream().write(pngBytes);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private Optional<AvatarTranscoder> getAvatarTranscoder() {
        return ComponentAccessor.getComponentSafely(AvatarTranscoder.class);
    }

    private boolean needsTranscoding(HttpServletRequest request) {
        if (request.getServletPath().endsWith(".svg")) {
            String format = request.getParameter("format");
            return StringUtils.isNotBlank((CharSequence)format) && "PNG".equals(format.toUpperCase());
        }
        return false;
    }

    private Avatar.Size getSize(HttpServletRequest request) {
        try {
            return Avatar.Size.getSizeFromParam((String)request.getParameter("size"));
        }
        catch (NoSuchElementException ex) {
            return Avatar.Size.defaultSize();
        }
    }

    public void destroy() {
    }
}

