/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.PluginAccessor;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileAppRequestFilter
extends AbstractHttpFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobileAppRequestFilter.class);
    private static final String MOBILE_REQUEST_HEADER_NAME = "mobile-app-request";
    private static final String MOBILE_DISABLED_HEADER_NAME = "mobile-app-disabled";
    private static final String MOBILE_PLUGIN_KEY = "com.atlassian.jira.mobile.jira-mobile-rest";
    private PluginAccessor pluginAccessor;

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.isMobileRequest(request) && this.isMobilePluginDisabled()) {
            response.setHeader(MOBILE_DISABLED_HEADER_NAME, "true");
            response.sendError(503);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean isMobileRequest(HttpServletRequest request) {
        String mobileRequestHeader = request.getHeader(MOBILE_REQUEST_HEADER_NAME);
        return StringUtils.isNotBlank((CharSequence)mobileRequestHeader) && Boolean.valueOf(mobileRequestHeader) != false;
    }

    private boolean isMobilePluginDisabled() {
        try {
            return this.getPluginAccessor() != null && !this.getPluginAccessor().isPluginEnabled(MOBILE_PLUGIN_KEY);
        }
        catch (Exception e) {
            LOGGER.error("Cannot get the mobile plugin status", (Throwable)e);
            return false;
        }
    }

    private PluginAccessor getPluginAccessor() {
        if (this.pluginAccessor == null) {
            this.pluginAccessor = ComponentAccessor.getPluginAccessor();
        }
        return this.pluginAccessor;
    }
}

