/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.subtask;

import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.component.subtask.AbstractSubTaskColumnLayoutItem;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class SubTaskReorderColumnLayoutItem
extends AbstractSubTaskColumnLayoutItem {
    private static final String REORDER_COLUMN_TEMPLATE_PATH = "templates/jira/issue/subtask/issue-subtask-reorder.vm";
    private int displaySequence = 0;
    private final boolean allowedReorderSubTasks;
    private final SubTaskBean subTaskBean;
    private final String subTaskView;
    private final String contextPath;
    private final Issue parentIssue;
    private final I18nHelper i18n;

    public SubTaskReorderColumnLayoutItem(PermissionManager permissionManager, ApplicationUser user, VelocityTemplatingEngine templatingEngine, SubTaskBean subTaskBean, String subTaskView, String contextPath, Issue parentIssue, I18nHelper i18n) {
        super(templatingEngine, subTaskBean, subTaskView);
        this.allowedReorderSubTasks = permissionManager.hasPermission(12, parentIssue, user);
        this.subTaskBean = subTaskBean;
        this.subTaskView = subTaskView;
        this.contextPath = contextPath;
        this.parentIssue = parentIssue;
        this.i18n = i18n;
    }

    @Override
    protected String getColumnCssClass() {
        return "streorder";
    }

    @Override
    protected Map<String, Object> getContext(Issue issue) {
        ++this.displaySequence;
        Long subtaskSequence = this.getCurrentSubTaskSequence(issue);
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"displaySequence", (Object)this.displaySequence).put((Object)"allowedReorderSubTasks", (Object)this.allowedReorderSubTasks).put((Object)"contextPath", (Object)this.contextPath).put((Object)"parentIssue", (Object)this.parentIssue).put((Object)"subtaskSequence", (Object)subtaskSequence).put((Object)"subTasksSize", (Object)this.getSubTasks().size());
        if (this.displaySequence != 1) {
            builder.put((Object)"previousSequence", (Object)this.subTaskBean.getPreviousSequence(subtaskSequence, this.subTaskView)).put((Object)"subtaskReorderMoveUpTitle", (Object)this.i18n.getText("admin.workflowdescriptor.move.up")).put((Object)"subtaskReorderMoveUpText", (Object)this.i18n.getText("admin.workflowdescriptor.move.up"));
        }
        if (this.displaySequence != this.getSubTasks().size()) {
            builder.put((Object)"nextSequence", (Object)this.subTaskBean.getNextSequence(subtaskSequence, this.subTaskView)).put((Object)"subtaskReorderMoveDownTitle", (Object)this.i18n.getText("admin.workflowdescriptor.move.down")).put((Object)"subtaskReorderMoveDownText", (Object)this.i18n.getText("admin.workflowdescriptor.move.down"));
        }
        return builder.build();
    }

    @Override
    protected String getTemplate() {
        return REORDER_COLUMN_TEMPLATE_PATH;
    }
}

