/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.BulkEditAction;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstantImpl;
import com.atlassian.jira.issue.IssueImpl;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comparator.BeanComparatorIgnoreCase;
import com.atlassian.jira.issue.comparator.KeyComparator;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.operation.BulkTransitionIssueOperation;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.security.IssueSecurityHelper;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeys;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.web.action.issue.bulkedit.WorkflowTransitionKey;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditMultiSelectFieldBean;
import com.atlassian.jira.web.bean.BulkEditMultiSelectFieldBeanImpl;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.jira.web.bean.MultiBulkMoveBeanImpl;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.mail.MailFactory;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class BulkEditBeanImpl
implements BulkEditBean {
    private int currentStep = 1;
    private final Set<Integer> availablePreviousSteps = new HashSet<Integer>();
    private Map<String, BulkEditAction> actions;
    private Project project;
    private Set<Long> projectIds;
    private Set<GenericValue> projects;
    private Set<Project> projectObjects;
    private Set<String> issueTypeIds;
    private Set<String> parentIssueKeys;
    private Set<Long> parentIssueIds;
    private Set<ProjectTypeKey> selectedProjectTypeKeys;
    private String operationName;
    private List<Issue> issuesFromSearchRequest;
    private List<Issue> selectedIssues;
    private List<Issue> subTaskOfSelectedIssues;
    private List<Long> selectedIssueIds;
    private List<Issue> selectedIssuesIncSubTasks;
    private BulkEditBean subTaskBulkEditBean;
    private Collection<?> issuesInUse;
    private final Map<String, Object> fieldValues = new HashMap<String, Object>();
    private final Map<String, Object> fieldValuesHolder = new HashMap<String, Object>();
    private Map<String, String> statusMapHolder = new HashMap<String, String>();
    private Map<String, Map<Long, Long>> fieldSubstitutionMap = new LinkedHashMap<String, Map<Long, Long>>();
    private Map<String, ?> params;
    private Set<FieldLayout> fieldLayouts;
    private Set<String> invalidSubTaskTypes;
    private Map<String, Set<String>> invalidSubTaskStatusesByType;
    private Collection<String> subTaskStatusHolder;
    private Set<Status> invalidStatuses;
    private Set<Issue> invalidIssues;
    private Set<?> removedFields;
    private FieldLayout targetFieldLayout;
    private Map<Issue, Issue> targetIssueObjects;
    private JiraWorkflow targetWorkflow;
    private Collection<?> moveFieldLayoutItems;
    private int subTaskCount = -1;
    private int invalidSubTaskCount = -1;
    private Set<String> retainValues;
    private Map<?, ?> messagedFieldLayoutItems;
    private boolean sendBulkNotification = false;
    private MultiMap workflowTransitionMap;
    private WorkflowTransitionKey selectedWFTransitionKey;
    private FieldScreenRenderer fieldScreenRenderer;
    private MultiBulkMoveBean relatedMultiBulkMoveBean;
    private BulkEditBean parentBulkEditBean;
    private final IssueManager issueManager;
    private Map<String, Collection<String>> transitionErrors = new LinkedHashMap<String, Collection<String>>();
    private int maxIssues = -1;
    private String singleIssueKey;
    private String redirectUrl;
    private boolean isRedirectUrlSet = false;
    private String parentIssueKey = null;
    private BulkEditMultiSelectFieldBean bulkEditMultiSelectFieldBean;

    public BulkEditBeanImpl(IssueManager issueManager) {
        this.issueManager = issueManager;
        this.bulkEditMultiSelectFieldBean = new BulkEditMultiSelectFieldBeanImpl();
    }

    public BulkEditBean getParentBulkEditBean() {
        return this.parentBulkEditBean;
    }

    public void initSelectedIssues(Collection<Issue> selectedIssues) {
        this.selectedIssues = null;
        this.setSelectedIssueIds(selectedIssues);
    }

    public void addIssues(Collection<Issue> issues) {
        this.selectedIssues = null;
        this.addIssueIds(issues);
        this.resetMoveData();
    }

    public List<Issue> getSelectedIssues() {
        if (this.selectedIssues == null) {
            this.initSelectedIssues();
        }
        return this.selectedIssues;
    }

    public List<Issue> getSelectedIssuesIncludingSubTasks() {
        if (this.selectedIssuesIncSubTasks == null) {
            this.initSelectedIssuesIncSubTasks();
        }
        return this.selectedIssuesIncSubTasks;
    }

    public boolean isChecked(Issue issue) {
        return this.getSelectedIssues().contains(issue);
    }

    public boolean isMultipleProjects() {
        return this.getProjectIds().size() > 1;
    }

    public boolean isMutipleIssueTypes() {
        return this.getIssueTypes().size() > 1;
    }

    public Project getProject() {
        if (this.project == null && !this.getProjectIds().isEmpty()) {
            this.project = ComponentAccessor.getProjectManager().getProjectObj(this.getProjectIds().iterator().next());
        }
        return this.project;
    }

    public Project getSingleProject() {
        Collection<Project> allProjects = this.getProjectObjects();
        if (allProjects.size() == 1) {
            return allProjects.iterator().next();
        }
        if (allProjects.size() > 1) {
            throw new IllegalStateException("Too many Projects only one is allowed");
        }
        throw new IllegalStateException("No projects found.");
    }

    public IssueType getIssueType() {
        if (!this.getIssueTypes().isEmpty()) {
            return ComponentAccessor.getConstantsManager().getIssueType(this.getIssueTypes().iterator().next());
        }
        return null;
    }

    public Collection<FieldLayout> getFieldLayouts() {
        if (this.fieldLayouts == null) {
            this.fieldLayouts = new HashSet<FieldLayout>();
            FieldLayoutManager fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
            for (Issue issue : this.getSelectedIssues()) {
                this.fieldLayouts.add(fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeId()));
            }
        }
        return this.fieldLayouts;
    }

    public String getKey() {
        StringBuilder key = new StringBuilder();
        for (Long projectId : this.getProjectIds()) {
            key.append(projectId);
        }
        key.append("_");
        for (IssueType issueType : this.getIssueTypeObjects()) {
            key.append(issueType.getId());
        }
        key.append("_");
        if (this.isSubTaskOnly()) {
            key.append(this.getTargetPid()).append("_");
            key.append(Optional.ofNullable(this.getParentIssueIds()).map(Collection::stream).orElse(Stream.empty()).map(Object::toString).reduce("", (ids, id) -> ids + id + "_"));
        }
        return key.toString();
    }

    public Collection<Long> getProjectIds() {
        if (this.projectIds == null) {
            this.initIssueProperties();
        }
        return this.projectIds;
    }

    public Collection<GenericValue> getProjects() {
        if (this.projects == null) {
            this.initIssueProperties();
        }
        return this.projects;
    }

    public Collection<Project> getProjectObjects() {
        if (this.projectObjects == null) {
            this.initIssueProperties();
        }
        return this.projectObjects;
    }

    public Collection<String> getIssueTypes() {
        if (this.issueTypeIds == null) {
            this.initIssueProperties();
        }
        return this.issueTypeIds;
    }

    public Collection<IssueType> getIssueTypeObjects() {
        return Transformed.collection(this.getIssueTypes(), input -> ComponentAccessor.getConstantsManager().getIssueTypeObject(input));
    }

    public Collection<String> getParentIssueKeys() {
        if (this.parentIssueKeys == null) {
            this.initIssueProperties();
        }
        return this.parentIssueKeys;
    }

    public Collection<Long> getParentIssueIds() {
        if (this.parentIssueIds == null) {
            this.initIssueProperties();
        }
        return this.parentIssueIds;
    }

    private void initIssueProperties() {
        this.projectIds = new HashSet<Long>();
        this.projects = new HashSet<GenericValue>();
        this.projectObjects = new HashSet<Project>();
        this.issueTypeIds = new HashSet<String>();
        this.parentIssueKeys = new HashSet<String>();
        this.parentIssueIds = new HashSet<Long>();
        for (Issue issue : this.getSelectedIssues()) {
            Project project = issue.getProjectObject();
            this.projectObjects.add(project);
            this.projects.add(project.getGenericValue());
            this.projectIds.add(project.getId());
            this.issueTypeIds.add(issue.getIssueTypeId());
            Issue parent = issue.getParentObject();
            if (parent == null) continue;
            this.parentIssueKeys.add(parent.getKey());
            this.parentIssueIds.add(parent.getId());
        }
    }

    private void initInvalidStatuses() throws WorkflowException {
        this.invalidStatuses = Sets.newHashSet();
        this.invalidIssues = new HashSet<Issue>();
        JiraWorkflow workflow = this.getWorkflowManager().getWorkflow(this.getTargetPid(), this.getTargetIssueTypeId());
        List validStatuses = workflow.getLinkedStatusObjects();
        for (Issue issue : this.getSelectedIssues()) {
            Status status = issue.getStatusObject();
            if (status == null) {
                this.invalidIssues.add(issue);
            }
            if (validStatuses.contains(status)) continue;
            this.invalidStatuses.add(status);
        }
    }

    public String getCheckboxName(Issue issue) {
        return "bulkedit_" + issue.getId();
    }

    public CustomField getCustomField(String customFieldKey) throws GenericEntityException {
        return ComponentAccessor.getCustomFieldManager().getCustomFieldObject(customFieldKey);
    }

    public String getCustomFieldView(CustomField customField) throws FieldValidationException {
        Object value = this.getFieldValues().get(customField.getId());
        FieldLayoutItem layoutItem = null;
        if (!this.getFieldLayouts().isEmpty()) {
            layoutItem = this.getFieldLayouts().iterator().next().getFieldLayoutItem((OrderableField)customField);
        }
        return customField.getCustomFieldType().getDescriptor().getViewHtml(customField, value, null, layoutItem);
    }

    private void refresh() {
        this.selectedIssueIds = null;
        this.selectedIssues = null;
        this.projectIds = null;
        this.project = null;
    }

    public void setParams(Map<String, ?> params) {
        this.params = params;
        this.refresh();
    }

    public Map<String, ?> getParams() {
        return this.params;
    }

    public void setIssuesInUse(Collection<?> issuesInUse) {
        this.issuesInUse = issuesInUse;
        this.project = null;
        this.projectIds = null;
        this.issueTypeIds = null;
    }

    public void addAvailablePreviousStep(int stepId) {
        this.availablePreviousSteps.add(new Integer(stepId));
    }

    public void clearAvailablePreviousSteps() {
        this.availablePreviousSteps.clear();
    }

    public boolean isAvailablePreviousStep(int stepId) {
        return this.availablePreviousSteps.contains(new Integer(stepId));
    }

    @Deprecated
    private static MutableIssue getIssueObject(GenericValue genericValue) {
        return IssueImpl.getIssueObject(genericValue);
    }

    public boolean isHasMailServer() {
        try {
            if (MailFactory.getServerManager().getDefaultSMTPMailServer() != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Collection<?> getMoveFieldLayoutItems() {
        return this.moveFieldLayoutItems;
    }

    public void setMoveFieldLayoutItems(Collection<?> moveFieldLayoutItems) {
        this.moveFieldLayoutItems = moveFieldLayoutItems;
    }

    public Long getTargetPid() {
        return (Long)this.getFieldValuesHolder().get("project");
    }

    public void setTargetProject(GenericValue project) {
        if (project != null) {
            this.getFieldValuesHolder().put("project", project.getLong("id"));
        } else {
            this.getFieldValuesHolder().put("project", null);
        }
    }

    public void setTargetProject(Project project) {
        if (project != null) {
            this.getFieldValuesHolder().put("project", project.getId());
        } else {
            this.getFieldValuesHolder().put("project", null);
        }
    }

    public Project getTargetProject() {
        return ComponentAccessor.getProjectManager().getProjectObj(this.getTargetPid());
    }

    public void setTargetIssueTypeId(String id) {
        this.getFieldValuesHolder().put("issuetype", id);
    }

    public String getTargetIssueTypeId() {
        return (String)this.getFieldValuesHolder().get("issuetype");
    }

    public IssueType getTargetIssueType() {
        return ComponentAccessor.getConstantsManager().getIssueType(this.getTargetIssueTypeId());
    }

    public IssueType getTargetIssueTypeObject() {
        return ComponentAccessor.getConstantsManager().getIssueTypeObject(this.getTargetIssueTypeId());
    }

    public void populateStatusHolder() throws WorkflowException {
        Map actionParameters = ActionContext.getParameters();
        for (GenericValue status : this.getInvalidStatuses()) {
            String statusKey = status.getString("id");
            this.statusMapHolder.put(statusKey, ParameterUtils.getStringParam((Map)actionParameters, (String)statusKey));
        }
    }

    public Collection<GenericValue> getInvalidStatuses() throws WorkflowException {
        if (this.invalidStatuses == null) {
            this.initInvalidStatuses();
        }
        return Collections2.transform(this.invalidStatuses, (Function)new StatusToStatusGV());
    }

    public Set<Issue> getInvalidIssues() throws WorkflowException {
        if (this.invalidIssues == null) {
            this.initInvalidStatuses();
        }
        return this.invalidIssues;
    }

    public Set<String> getInvalidSubTaskTypes() throws WorkflowException {
        if (this.invalidSubTaskTypes == null) {
            this.invalidSubTaskTypes = new HashSet<String>();
            this.invalidSubTaskCount = 0;
            List<Issue> selectedIssues = this.getSelectedIssues();
            ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
            for (Issue issue : selectedIssues) {
                Collection subTasks = issue.getSubTasks();
                for (GenericValue subTask : subTasks) {
                    HashSet<String> invalidStatuses;
                    String subTaskTypeId = subTask.getString("type");
                    String subTaskStatusId = subTask.getString("status");
                    Status subTaskStatus = constantsManager.getStatus(subTaskStatusId);
                    JiraWorkflow targetSubTaskWorkflow = this.getWorkflowForType(this.getTargetPid(), subTaskTypeId);
                    if (targetSubTaskWorkflow.getLinkedStatusObjects().contains(subTaskStatus)) continue;
                    this.invalidSubTaskTypes.add(subTaskTypeId);
                    ++this.invalidSubTaskCount;
                    if (this.invalidSubTaskStatusesByType != null && !this.invalidSubTaskStatusesByType.isEmpty()) {
                        if (this.invalidSubTaskStatusesByType.containsKey(subTaskTypeId)) {
                            invalidStatuses = new HashSet(this.invalidSubTaskStatusesByType.get(subTaskTypeId));
                            invalidStatuses.add(subTaskStatusId);
                            this.invalidSubTaskStatusesByType.put(subTaskTypeId, invalidStatuses);
                            continue;
                        }
                        invalidStatuses = new HashSet();
                        invalidStatuses.add(subTaskStatus.getId());
                        this.invalidSubTaskStatusesByType.put(subTaskTypeId, invalidStatuses);
                        continue;
                    }
                    this.invalidSubTaskStatusesByType = new HashMap<String, Set<String>>();
                    invalidStatuses = new HashSet<String>();
                    invalidStatuses.add(subTaskStatus.getId());
                    this.invalidSubTaskStatusesByType.put(subTaskTypeId, invalidStatuses);
                }
            }
        }
        return this.invalidSubTaskTypes;
    }

    public Set<String> getInvalidSubTaskStatusesByType(String subTaskTypeId) throws WorkflowException {
        if (this.invalidSubTaskStatusesByType == null) {
            this.getInvalidSubTaskTypes();
        }
        return this.invalidSubTaskStatusesByType.get(subTaskTypeId);
    }

    public void setTargetFieldLayout() {
        FieldLayoutManager fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        this.targetFieldLayout = fieldLayoutManager.getFieldLayout(this.getTargetProject(), this.getTargetIssueTypeId());
    }

    public FieldLayout getTargetFieldLayout() {
        return this.targetFieldLayout;
    }

    public FieldLayout getTargetFieldLayoutForType(String targetTypeId) {
        FieldLayoutManager fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        return fieldLayoutManager.getFieldLayout(this.getTargetProject(), targetTypeId);
    }

    public JiraWorkflow getTargetWorkflow() throws WorkflowException {
        if (this.targetWorkflow == null) {
            this.targetWorkflow = this.getWorkflowForType(this.getTargetPid(), this.getTargetIssueTypeId());
        }
        return this.targetWorkflow;
    }

    public Issue getFirstTargetIssueObject() {
        if (this.getTargetIssueObjects().isEmpty()) {
            return null;
        }
        return this.getTargetIssueObjects().values().iterator().next();
    }

    public Map<Issue, Issue> getTargetIssueObjects() {
        if (this.targetIssueObjects == null) {
            this.targetIssueObjects = new HashMap<Issue, Issue>();
            for (Issue selectedIssue : this.getSelectedIssues()) {
                MutableIssue cloneIssue = this.issueManager.getIssueObject(selectedIssue.getId());
                if (this.getTargetPid() != null) {
                    cloneIssue.setProjectId(this.getTargetPid());
                }
                cloneIssue.setIssueTypeId(this.getTargetIssueTypeId());
                if (this.getParentIssueObject() != null) {
                    cloneIssue.setParentObject(this.getParentIssueObject());
                } else if (this.parentBulkEditBean != null && cloneIssue.isSubTask()) {
                    Issue parent = this.getParentTargetIssue(cloneIssue.getParentId());
                    if (parent == null) {
                        throw new IllegalStateException("Could not find parent [" + cloneIssue.getParentId() + "] for subtask [" + cloneIssue.getId() + "] in the parent BulkEditBean.");
                    }
                    cloneIssue.setParentObject(parent);
                } else if (this.getTargetIssueType() != null && !this.getTargetIssueType().isSubTask()) {
                    cloneIssue.setParentObject(null);
                    cloneIssue = new MutableIssueFromSubtaskToIssue(cloneIssue);
                }
                IssueSecurityHelper issueSecurityHelper = this.getIssueSecurityHelper();
                if (issueSecurityHelper.securityLevelNeedsMove(selectedIssue, (Issue)cloneIssue)) {
                    cloneIssue.setSecurityLevel(null);
                }
                this.targetIssueObjects.put(selectedIssue, (Issue)cloneIssue);
            }
        }
        return this.targetIssueObjects;
    }

    private Issue getParentTargetIssue(Long issueId) {
        if (issueId == null) {
            return null;
        }
        for (Issue issue : this.parentBulkEditBean.getTargetIssueObjects().values()) {
            if (!issueId.equals(issue.getId())) continue;
            return issue;
        }
        return null;
    }

    public void setTargetIssueObjects(Map<Issue, Issue> targetIssueObjects) {
        this.targetIssueObjects = targetIssueObjects;
    }

    public List<GenericValue> getTargetIssueGVs() {
        Collection<Issue> values = this.getTargetIssueObjects().values();
        ArrayList gvs = Lists.newArrayListWithCapacity((int)values.size());
        for (Issue issue : values) {
            gvs.add(issue.getGenericValue());
        }
        return gvs;
    }

    public Status getTargetStatusObject(Issue issue) {
        return this.getTargetStatus(issue);
    }

    public Status getTargetStatus(Issue issue) {
        String statusId = this.statusMapHolder.get(issue.getStatusObject().getId());
        if (statusId != null) {
            return ComponentAccessor.getConstantsManager().getStatus(statusId);
        }
        return null;
    }

    private JiraWorkflow getWorkflowForType(Long projectId, String issueTypeId) throws WorkflowException {
        return this.getWorkflowManager().getWorkflow(projectId, issueTypeId);
    }

    public Map<String, String> getStatusMapHolder() {
        return this.statusMapHolder;
    }

    public Collection<?> getRemovedFields() {
        return this.removedFields;
    }

    public void setRemovedFields(Set<?> removedFields) {
        this.removedFields = removedFields;
    }

    public void resetMoveData() {
        if (this.getMoveFieldLayoutItems() != null && !this.getMoveFieldLayoutItems().isEmpty()) {
            this.setSelectedIssueIds(this.getSelectedIssues());
            this.selectedIssues = null;
        }
        this.setRemovedFields(null);
        this.setMoveFieldLayoutItems(null);
        this.setInvalidSubTaskTypes(null);
        this.setInvalidSubTaskStatusesByType(null);
        this.setRetainValues(null);
        this.setTargetIssueObjects(null);
        this.setInvalidStatuses(null);
        this.invalidIssues = null;
        this.setSubTaskBulkEditBean(null);
        this.setRelatedMultiBulkMoveBean(null);
        this.statusMapHolder = new HashMap<String, String>();
        this.projectIds = null;
        this.projects = null;
        this.projectObjects = null;
        this.issueTypeIds = null;
    }

    public void populateSubTaskStatusHolder() throws WorkflowException {
        Map actionParameters = ActionContext.getParameters();
        this.subTaskStatusHolder = Lists.newArrayListWithCapacity((int)actionParameters.size());
        for (String actionKey : actionParameters.keySet()) {
            String[] value;
            if (actionKey.indexOf("subtaskstatusinfo_") == -1 || (value = (String[])actionParameters.get(actionKey)) == null || value.length == 0) continue;
            this.subTaskStatusHolder.add(actionKey + "_" + value[0]);
        }
    }

    public JiraWorkflow getTargetWorkflowByType(String issueTypeId) throws WorkflowException {
        return this.getWorkflowForType(this.getTargetPid(), issueTypeId);
    }

    private WorkflowManager getWorkflowManager() {
        return ComponentAccessor.getWorkflowManager();
    }

    private void initSelectedIssuesIncSubTasks() {
        HashSet<Issue> issueSet = new HashSet<Issue>();
        issueSet.addAll(this.getSelectedIssues());
        issueSet.addAll(this.getSubTaskOfSelectedIssues());
        this.selectedIssuesIncSubTasks = new ArrayList<Issue>(issueSet);
        Collections.sort(this.selectedIssuesIncSubTasks, new BeanComparatorIgnoreCase("key"));
    }

    private void initSelectedIssues() {
        this.subTaskCount = 0;
        this.selectedIssues = new ArrayList<Issue>();
        this.subTaskOfSelectedIssues = new ArrayList<Issue>();
        for (Long issueId : this.getSelectedIds()) {
            MutableIssue issue = this.issueManager.getIssueObject(issueId);
            if (issue == null) continue;
            if (issue.isSubTask()) {
                ++this.subTaskCount;
            }
            this.selectedIssues.add((Issue)issue);
            this.subTaskOfSelectedIssues.addAll(issue.getSubTaskObjects());
        }
    }

    private List<Long> getSelectedIds() {
        if (this.selectedIssueIds == null) {
            this.selectedIssueIds = new ArrayList<Long>();
            if (this.getParams() == null) {
                return this.selectedIssueIds;
            }
            for (String issueKey : this.getParams().keySet()) {
                if (!issueKey.startsWith("bulkedit_")) continue;
                this.selectedIssueIds.add(new Long(issueKey.substring("bulkedit_".length())));
            }
        }
        return this.selectedIssueIds;
    }

    private void setSelectedIssueIds(Collection<Issue> issues) {
        if (this.selectedIssueIds == null) {
            this.selectedIssueIds = new ArrayList<Long>();
        } else {
            this.selectedIssueIds.clear();
        }
        this.addIssueIds(issues);
    }

    private void addIssueIds(Collection<Issue> issues) {
        for (Issue issue : issues) {
            this.selectedIssueIds.add(issue.getId());
        }
    }

    public Collection<String> getSubTaskStatusHolder() {
        return this.subTaskStatusHolder;
    }

    public boolean isRetainChecked(String fieldId) {
        return this.retainValues == null ? false : this.retainValues.contains(fieldId);
    }

    public boolean isSubTaskCollection() {
        return this.getSubTaskCount() > 0;
    }

    public boolean isSubTaskOnly() {
        return this.getSubTaskCount() == this.getSelectedIds().size();
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public void setInvalidSubTaskStatusesByType(Map<String, Set<String>> invalidSubTaskStatusesByType) {
        this.invalidSubTaskStatusesByType = invalidSubTaskStatusesByType;
    }

    public void setInvalidSubTaskTypes(Set<String> invalidSubTaskTypes) {
        this.invalidSubTaskTypes = invalidSubTaskTypes;
    }

    private int getSubTaskCount() {
        if (this.selectedIssues == null) {
            this.initSelectedIssues();
        }
        return this.subTaskCount;
    }

    public int getInvalidSubTaskCount() {
        return this.invalidSubTaskCount;
    }

    public Set<String> getRetainValues() {
        return this.retainValues;
    }

    public void setRetainValues(Set<String> retainValues) {
        this.retainValues = retainValues;
    }

    public void addRetainValue(String fieldId) {
        if (this.retainValues == null) {
            this.retainValues = new HashSet<String>();
        }
        this.retainValues.add(fieldId);
    }

    private void setInvalidStatuses(Set<Status> invalidStatuses) {
        this.invalidStatuses = invalidStatuses;
    }

    public List<Issue> getSubTaskOfSelectedIssues() {
        return this.subTaskOfSelectedIssues;
    }

    public void setSubTaskOfSelectedIssues(List<Issue> subTaskOfSelectedIssues) {
        this.subTaskOfSelectedIssues = subTaskOfSelectedIssues;
    }

    public List<Issue> getIssuesFromSearchRequest() {
        return this.issuesFromSearchRequest;
    }

    public void setIssuesFromSearchRequest(List<Issue> issuesFromSearchRequest) {
        this.issuesFromSearchRequest = issuesFromSearchRequest;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public Map<String, BulkEditAction> getActions() {
        return this.actions;
    }

    public void setActions(Map<String, BulkEditAction> actions) {
        this.actions = actions;
    }

    public Map<String, Object> getFieldValues() {
        return this.fieldValues;
    }

    public Map<String, Object> getFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    public IssueOperation getIssueOperation() {
        BulkOperationManager bulkOperationManager = ComponentAccessor.getBulkOperationManager();
        if ("BulkWorkflowTransition".equals(this.getOperationName())) {
            JiraWorkflow workflow = ComponentAccessor.getWorkflowManager().getWorkflow(this.getSelectedWFTransitionKey().getWorkflowName());
            ActionDescriptor action = workflow.getDescriptor().getAction(Integer.parseInt(this.getSelectedWFTransitionKey().getActionDescriptorId()));
            return new BulkTransitionIssueOperation(bulkOperationManager.getProgressAwareOperation(this.getOperationName()), action);
        }
        return bulkOperationManager.getOperation(this.getOperationName());
    }

    public Collection<?> getIssuesInUse() {
        return this.issuesInUse;
    }

    public BulkEditBean getSubTaskBulkEditBean() {
        return this.subTaskBulkEditBean;
    }

    public void setSubTaskBulkEditBean(BulkEditBean subTaskBulkEditBean) {
        this.subTaskBulkEditBean = subTaskBulkEditBean;
    }

    public MultiBulkMoveBean getRelatedMultiBulkMoveBean() {
        return this.relatedMultiBulkMoveBean;
    }

    public void setRelatedMultiBulkMoveBean(MultiBulkMoveBean relatedMultiBulkMoveBean) {
        this.relatedMultiBulkMoveBean = relatedMultiBulkMoveBean;
    }

    public boolean isSendBulkNotification() {
        return this.sendBulkNotification;
    }

    public void setSendBulkNotification(boolean sendBulkNotification) {
        this.sendBulkNotification = sendBulkNotification;
    }

    public MultiMap getWorkflowTransitionMap() {
        return this.workflowTransitionMap;
    }

    public void setWorkflowTransitionMap(MultiMap workflowTransitionMap) {
        this.workflowTransitionMap = workflowTransitionMap;
    }

    public Set<String> getWorkflowsInUse() {
        Set workflowTransitionMapKeys = this.workflowTransitionMap.keySet();
        return CollectionUtil.transformSet((Iterable)workflowTransitionMapKeys, input -> input.getWorkflowName());
    }

    public List<WorkflowTransitionKey> getTransitionIdsForWorkflow(String workflowName) {
        Set workflowTransitionMaps = this.workflowTransitionMap.keySet();
        ArrayList transitionIdsForWorkflow = Lists.newArrayListWithCapacity((int)workflowTransitionMaps.size());
        for (WorkflowTransitionKey wfTransitionKey : workflowTransitionMaps) {
            if (!wfTransitionKey.getWorkflowName().equals(workflowName)) continue;
            transitionIdsForWorkflow.add(wfTransitionKey);
        }
        Collections.sort(transitionIdsForWorkflow, new Comparator<WorkflowTransitionKey>(){

            @Override
            public int compare(WorkflowTransitionKey o1, WorkflowTransitionKey o2) {
                return o1.getActionDescriptorId().compareTo(o2.getActionDescriptorId());
            }
        });
        return transitionIdsForWorkflow;
    }

    public String getTransitionName(String workflowName, String actionDescriptorId) {
        String key;
        I18nBean i18nBean;
        String value;
        JiraWorkflow workflow = ComponentAccessor.getWorkflowManager().getWorkflow(workflowName);
        ActionDescriptor descriptor = workflow.getDescriptor().getAction(Integer.parseInt(actionDescriptorId));
        Map metadata = descriptor.getMetaAttributes();
        if (metadata.containsKey("jira.issue.editable") && (value = (i18nBean = new I18nBean()).getText(key = (String)metadata.get("jira.issue.editable"))) != null && !"".equals(value.trim()) && !value.trim().equals(key.trim())) {
            return value;
        }
        return descriptor.getName();
    }

    public List<String> getTransitionIssueKeys(WorkflowTransitionKey workflowTransitionKey) {
        ArrayList<String> workflowIssues = new ArrayList<String>((List)this.workflowTransitionMap.get((Object)workflowTransitionKey));
        Collections.sort(workflowIssues, KeyComparator.COMPARATOR);
        return workflowIssues;
    }

    public void setSelectedWFTransitionKey(WorkflowTransitionKey workflowTransitionKey) {
        this.selectedWFTransitionKey = workflowTransitionKey;
    }

    public WorkflowTransitionKey getSelectedWFTransitionKey() {
        return this.selectedWFTransitionKey;
    }

    public void resetWorkflowTransitionSelection() {
        this.selectedWFTransitionKey = null;
    }

    public boolean isTransitionChecked(WorkflowTransitionKey workflowTransitionKey) {
        return this.selectedWFTransitionKey != null && this.selectedWFTransitionKey.equals((Object)workflowTransitionKey);
    }

    public String getSelectedTransitionName() {
        return this.getTransitionName(this.selectedWFTransitionKey.getWorkflowName(), this.selectedWFTransitionKey.getActionDescriptorId());
    }

    public void setFieldScreenRenderer(FieldScreenRenderer fieldScreenRenderer) {
        this.fieldScreenRenderer = fieldScreenRenderer;
    }

    public FieldScreenRenderer getFieldScreenRenderer() {
        return this.fieldScreenRenderer;
    }

    @Deprecated
    public void _setSelectedIssueGVsForTesting(List<GenericValue> issues) {
        if (issues != null) {
            this.selectedIssues = new ArrayList<Issue>(issues.size());
            for (GenericValue issueGV : issues) {
                this.selectedIssues.add((Issue)BulkEditBeanImpl.getIssueObject(issueGV));
            }
        } else {
            this.selectedIssues = null;
        }
    }

    public Map<?, ?> getMessagedFieldLayoutItems() {
        return this.messagedFieldLayoutItems;
    }

    public void setMessagedFieldLayoutItems(Map<?, ?> messagedFieldLayoutItems) {
        this.messagedFieldLayoutItems = messagedFieldLayoutItems;
    }

    public void initMultiBulkBean() {
        MultiBulkMoveBeanImpl multiBulkMoveBean = new MultiBulkMoveBeanImpl(this.getOperationName(), this.issueManager);
        multiBulkMoveBean.initFromIssues(this.getSelectedIssues(), null);
        this.initSingleIssueMultiBulkMoveBean(multiBulkMoveBean);
        this.setRelatedMultiBulkMoveBean(multiBulkMoveBean);
    }

    public void initMultiBulkBeanWithSubTasks() {
        List selectedIssues = this.getSubTaskBulkEditBean().getSelectedIssues();
        MultiBulkMoveBeanImpl multiBulkMoveBean = new MultiBulkMoveBeanImpl(this.getOperationName(), this.issueManager);
        multiBulkMoveBean.initFromIssues(selectedIssues, this);
        this.initSingleIssueMultiBulkMoveBean(multiBulkMoveBean);
        multiBulkMoveBean.setTargetProject(this.getTargetProject());
        multiBulkMoveBean.setParentIssueKey(this.getParentIssueKey());
        this.setRelatedMultiBulkMoveBean(multiBulkMoveBean);
    }

    private void initSingleIssueMultiBulkMoveBean(MultiBulkMoveBean multiBulkMoveBean) {
        ListOrderedMap bulkEditBeans = multiBulkMoveBean.getBulkEditBeans();
        List valueList = bulkEditBeans.valueList();
        for (Object editBean : valueList) {
            ((BulkEditBean)editBean).setSingleIssueKey(this.singleIssueKey);
        }
    }

    public boolean isOnlyContainsSubTasks() {
        return this.getSubTaskCount() == this.getSelectedIssues().size();
    }

    public void setParentBulkEditBean(BulkEditBean parentBulkEditBean) {
        this.parentBulkEditBean = parentBulkEditBean;
    }

    IssueSecurityHelper getIssueSecurityHelper() {
        return (IssueSecurityHelper)ComponentAccessor.getComponent(IssueSecurityHelper.class);
    }

    public int getMaxIssues() {
        return this.maxIssues;
    }

    public void setMaxIssues(int maxIssues) {
        if (maxIssues < -1) {
            throw new IllegalArgumentException("max issues for bulk edit cannot be " + maxIssues);
        }
        this.maxIssues = maxIssues;
    }

    public Map<String, Map<Long, Long>> getFieldSubstitutionMap() {
        return this.fieldSubstitutionMap;
    }

    public Map<String, Collection<String>> getTransitionErrors(@Nullable Integer maxCount) {
        if (maxCount != null && this.isTranisitionErrorsLimited(maxCount)) {
            final LinkedHashSet limitedKeys = Sets.newLinkedHashSet((Iterable)Iterables.limit(this.transitionErrors.keySet(), (int)maxCount));
            return Maps.filterKeys(this.transitionErrors, (Predicate)new Predicate<String>(){

                public boolean apply(String key) {
                    return limitedKeys.contains(key);
                }
            });
        }
        return this.transitionErrors;
    }

    public void addTransitionErrors(@Nonnull String issueKey, @Nonnull Collection<String> errors) {
        this.transitionErrors.put(issueKey, errors);
    }

    public boolean isTranisitionErrorsLimited(@Nullable Integer maxCount) {
        return maxCount != null && this.transitionErrors.size() > maxCount;
    }

    public BulkEditMultiSelectFieldBean getBulkEditMultiSelectFieldBean() {
        return this.bulkEditMultiSelectFieldBean;
    }

    public boolean isSingleMode() {
        return this.singleIssueKey != null;
    }

    public void setSingleIssueKey(String singleIssueKey) {
        this.singleIssueKey = singleIssueKey;
    }

    public String getSingleIssueKey() {
        return this.singleIssueKey;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        this.isRedirectUrlSet = true;
    }

    public boolean isRedirectUrlSet() {
        return this.isRedirectUrlSet;
    }

    public String getParentIssueKey() {
        return this.parentIssueKey;
    }

    public void setParentIssueKey(String parentIssueKey) {
        this.parentIssueKey = StringUtils.isBlank((CharSequence)parentIssueKey) ? null : parentIssueKey;
    }

    public Issue getParentIssueObject() {
        return Optional.ofNullable(this.getParentIssueKey()).map(key -> this.issueManager.getIssueObject(key)).orElse(null);
    }

    private Set<ProjectTypeKey> getSelectedProjectTypes() {
        if (this.selectedProjectTypeKeys == null) {
            this.selectedProjectTypeKeys = this.selectedIssues.stream().map(Issue::getProjectObject).map(Project::getProjectTypeKey).collect(Collectors.toSet());
        }
        return this.selectedProjectTypeKeys;
    }

    public boolean isServiceDeskProjectIssuesPresent() {
        return this.getSelectedProjectTypes().contains(ProjectTypeKeys.SERVICE_DESK);
    }

    public boolean isSoftwareProjectIssuesPresent() {
        return this.getSelectedProjectTypes().contains(ProjectTypeKeys.SOFTWARE);
    }

    private class MutableIssueFromSubtaskToIssue
    implements MutableIssue {
        private final MutableIssue delegate;

        private MutableIssueFromSubtaskToIssue(MutableIssue delegate) {
            this.delegate = delegate;
        }

        public void setProject(GenericValue project) {
            this.delegate.setProject(project);
        }

        public void setProjectObject(Project project) {
            this.delegate.setProjectObject(project);
        }

        public void setProjectId(Long projectId) throws IllegalArgumentException {
            this.delegate.setProjectId(projectId);
        }

        public void setIssueType(IssueType issueType) {
            this.delegate.setIssueType(issueType);
        }

        public void setIssueTypeObject(IssueType issueType) {
            this.delegate.setIssueTypeObject(issueType);
        }

        public void setIssueTypeId(String issueTypeId) {
            this.delegate.setIssueTypeId(issueTypeId);
        }

        public void setSummary(String summary) {
            this.delegate.setSummary(summary);
        }

        public void setAssignee(ApplicationUser assignee) {
            this.delegate.setAssignee(assignee);
        }

        public void setComponent(Collection<ProjectComponent> components) {
            this.delegate.setComponent(components);
        }

        public void setAssigneeId(String assigneeId) {
            this.delegate.setAssigneeId(assigneeId);
        }

        public void setReporter(ApplicationUser reporter) {
            this.delegate.setReporter(reporter);
        }

        public void setReporterId(String reporterId) {
            this.delegate.setReporterId(reporterId);
        }

        public void setDescription(String description) {
            this.delegate.setDescription(description);
        }

        public void setEnvironment(String environment) {
            this.delegate.setEnvironment(environment);
        }

        public void setAffectedVersions(Collection<Version> affectedVersions) {
            this.delegate.setAffectedVersions(affectedVersions);
        }

        public void setFixVersions(Collection<Version> fixVersions) {
            this.delegate.setFixVersions(fixVersions);
        }

        public void setDueDate(Timestamp dueDate) {
            this.delegate.setDueDate(dueDate);
        }

        public void setSecurityLevelId(Long securityLevelId) {
            this.delegate.setSecurityLevelId(securityLevelId);
        }

        public void setSecurityLevel(GenericValue securityLevel) {
            this.delegate.setSecurityLevel(securityLevel);
        }

        public void setPriority(@Nullable Priority priority) {
            this.delegate.setPriority(priority);
        }

        public void setPriorityObject(@Nullable Priority priority) {
            this.delegate.setPriorityObject(priority);
        }

        public void setPriorityId(String priorityId) {
            this.delegate.setPriorityId(priorityId);
        }

        public void setResolution(Resolution resolution) {
            this.delegate.setResolution(resolution);
        }

        public void setResolutionObject(Resolution resolution) {
            this.delegate.setResolutionObject(resolution);
        }

        public void setKey(String key) {
            this.delegate.setKey(key);
        }

        public void setNumber(Long number) {
            this.delegate.setNumber(number);
        }

        public void setVotes(Long votes) {
            this.delegate.setVotes(votes);
        }

        public void setWatches(Long votes) {
            this.delegate.setWatches(votes);
        }

        public void setCreated(Timestamp created) {
            this.delegate.setCreated(created);
        }

        public void setUpdated(Timestamp updated) {
            this.delegate.setUpdated(updated);
        }

        public void setResolutionDate(Timestamp resolutionDate) {
            this.delegate.setResolutionDate(resolutionDate);
        }

        public void setWorkflowId(Long workflowId) {
            this.delegate.setWorkflowId(workflowId);
        }

        public void setCustomFieldValue(CustomField customField, Object value) {
            this.delegate.setCustomFieldValue(customField, value);
        }

        public void setStatus(Status status) {
            this.delegate.setStatus(status);
        }

        public void setStatusObject(Status status) {
            this.delegate.setStatusObject(status);
        }

        public void setStatusId(String statusId) {
            this.delegate.setStatusId(statusId);
        }

        public void resetModifiedFields() {
            this.delegate.resetModifiedFields();
        }

        public void setOriginalEstimate(Long estimate) {
            this.delegate.setOriginalEstimate(estimate);
        }

        public void setTimeSpent(Long timespent) {
            this.delegate.setTimeSpent(timespent);
        }

        public void setEstimate(Long estimate) {
            this.delegate.setEstimate(estimate);
        }

        public void setExternalFieldValue(String fieldId, Object newValue) {
            this.delegate.setExternalFieldValue(fieldId, newValue);
        }

        public void setExternalFieldValue(String fieldId, Object oldValue, Object newValue) {
            this.delegate.setExternalFieldValue(fieldId, oldValue, newValue);
        }

        public void setParentId(Long parentId) {
            this.delegate.setParentId(parentId);
        }

        public void setParentObject(Issue parentIssue) {
            this.delegate.setParentObject(parentIssue);
        }

        public void setResolutionId(String resolutionId) {
            this.delegate.setResolutionId(resolutionId);
        }

        public void setArchived(boolean archived) {
            this.delegate.setArchived(archived);
        }

        public ApplicationUser getArchivedByUser() {
            return this.delegate.getArchivedByUser();
        }

        public String getArchivedById() {
            return this.delegate.getArchivedById();
        }

        public Timestamp getArchivedDate() {
            return this.delegate.getArchivedDate();
        }

        public void setLabels(Set<Label> labels) {
            this.delegate.setLabels(labels);
        }

        public Map<String, ModifiedValue> getModifiedFields() {
            return this.delegate.getModifiedFields();
        }

        @Internal
        public void store() {
            this.delegate.store();
        }

        public Long getId() {
            return this.delegate.getId();
        }

        @Deprecated
        public GenericValue getProject() {
            return this.delegate.getProject();
        }

        public Project getProjectObject() {
            return this.delegate.getProjectObject();
        }

        public Long getProjectId() {
            return this.delegate.getProjectId();
        }

        public IssueType getIssueType() {
            return this.delegate.getIssueType();
        }

        @Deprecated
        public IssueType getIssueTypeObject() {
            return this.delegate.getIssueTypeObject();
        }

        public String getIssueTypeId() {
            return this.delegate.getIssueTypeId();
        }

        public String getSummary() {
            return this.delegate.getSummary();
        }

        public ApplicationUser getAssigneeUser() {
            return this.delegate.getAssigneeUser();
        }

        public ApplicationUser getAssignee() {
            return this.delegate.getAssignee();
        }

        public String getAssigneeId() {
            return this.delegate.getAssigneeId();
        }

        @Deprecated
        public Collection<ProjectComponent> getComponentObjects() {
            return this.delegate.getComponentObjects();
        }

        public Collection<ProjectComponent> getComponents() {
            return this.delegate.getComponents();
        }

        public ApplicationUser getReporterUser() {
            return this.delegate.getReporterUser();
        }

        public ApplicationUser getReporter() {
            return this.delegate.getReporter();
        }

        public String getReporterId() {
            return this.delegate.getReporterId();
        }

        public ApplicationUser getCreator() {
            return this.delegate.getCreator();
        }

        public String getCreatorId() {
            return this.delegate.getCreatorId();
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }

        public String getEnvironment() {
            return this.delegate.getEnvironment();
        }

        public Collection<Version> getAffectedVersions() {
            return this.delegate.getAffectedVersions();
        }

        public Collection<Version> getFixVersions() {
            return this.delegate.getFixVersions();
        }

        public Timestamp getDueDate() {
            return this.delegate.getDueDate();
        }

        public GenericValue getSecurityLevel() {
            return this.delegate.getSecurityLevel();
        }

        public Long getSecurityLevelId() {
            return this.delegate.getSecurityLevelId();
        }

        @Nullable
        public Priority getPriority() {
            return this.delegate.getPriority();
        }

        @Nullable
        public Priority getPriorityObject() {
            return this.delegate.getPriorityObject();
        }

        public String getResolutionId() {
            return this.delegate.getResolutionId();
        }

        public Resolution getResolution() {
            return this.delegate.getResolution();
        }

        @Deprecated
        public Resolution getResolutionObject() {
            return this.delegate.getResolutionObject();
        }

        public String getKey() {
            return this.delegate.getKey();
        }

        public Long getNumber() {
            return this.delegate.getNumber();
        }

        public Long getVotes() {
            return this.delegate.getVotes();
        }

        public Long getWatches() {
            return this.delegate.getWatches();
        }

        public Timestamp getCreated() {
            return this.delegate.getCreated();
        }

        public Timestamp getUpdated() {
            return this.delegate.getUpdated();
        }

        public Timestamp getResolutionDate() {
            return this.delegate.getResolutionDate();
        }

        public Long getWorkflowId() {
            return this.delegate.getWorkflowId();
        }

        public Object getCustomFieldValue(CustomField customField) {
            return this.delegate.getCustomFieldValue(customField);
        }

        public Status getStatus() {
            return this.delegate.getStatus();
        }

        public String getStatusId() {
            return this.delegate.getStatusId();
        }

        @Deprecated
        public Status getStatusObject() {
            return this.delegate.getStatusObject();
        }

        public Long getOriginalEstimate() {
            return this.delegate.getOriginalEstimate();
        }

        public Long getEstimate() {
            return this.delegate.getEstimate();
        }

        public Long getTimeSpent() {
            return this.delegate.getTimeSpent();
        }

        public Object getExternalFieldValue(String fieldId) {
            return this.delegate.getExternalFieldValue(fieldId);
        }

        public boolean isSubTask() {
            return false;
        }

        public Long getParentId() {
            return null;
        }

        public boolean isCreated() {
            return this.delegate.isCreated();
        }

        public Issue getParentObject() {
            return null;
        }

        @Deprecated
        public GenericValue getParent() {
            return this.delegate.getParent();
        }

        @Deprecated
        public Collection<GenericValue> getSubTasks() {
            return this.delegate.getSubTasks();
        }

        public Collection<Issue> getSubTaskObjects() {
            return this.delegate.getSubTaskObjects();
        }

        public boolean isEditable() {
            return this.delegate.isEditable();
        }

        public IssueRenderContext getIssueRenderContext() {
            return this.delegate.getIssueRenderContext();
        }

        public Collection<Attachment> getAttachments() {
            return this.delegate.getAttachments();
        }

        public Set<Label> getLabels() {
            return this.delegate.getLabels();
        }

        public boolean isArchived() {
            return this.delegate.isArchived();
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public GenericValue getGenericValue() {
            return this.delegate.getGenericValue();
        }

        public String getString(String name) {
            return this.delegate.getString(name);
        }

        public Timestamp getTimestamp(String name) {
            return this.delegate.getTimestamp(name);
        }

        public Long getLong(String name) {
            return this.delegate.getLong(name);
        }
    }

    private static class StatusToStatusGV
    implements Function<Status, GenericValue> {
        private StatusToStatusGV() {
        }

        public GenericValue apply(@Nullable Status status) {
            return status != null ? ((IssueConstantImpl)status).getGenericValue() : null;
        }
    }
}

