/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.web.action.util.ImportResultHandler;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevels;
import java.util.Collection;
import java.util.Objects;

public class DefaultImportResultHandler
implements ImportResultHandler {
    private final JohnsonProvider johnsonProvider;
    private final LicenseJohnsonEventRaiser licenseJohnsonEventRaiser;

    public DefaultImportResultHandler(JohnsonProvider johnsonProvider, LicenseJohnsonEventRaiser licenseJohnsonEventRaiser) {
        this.johnsonProvider = Objects.requireNonNull(johnsonProvider);
        this.licenseJohnsonEventRaiser = Objects.requireNonNull(licenseJohnsonEventRaiser);
    }

    @Override
    public boolean handleErrorResult(DataImportService.ImportResult importResult, I18nHelper i18n, ErrorCollection errorCollection) {
        switch (importResult.getImportError()) {
            case UPGRADE_EXCEPTION: {
                if (!this.checkLicenseIsInvalidOrTooOldForBuild()) {
                    Event upgradeErrorEvent = new Event(JohnsonEventType.UPGRADE.eventType(), "An error occurred performing JIRA upgrade task", importResult.getSpecificErrorMessage(), EventLevels.error());
                    this.johnsonProvider.getContainer().addEvent(upgradeErrorEvent);
                }
                return true;
            }
            case CUSTOM_PATH_EXCEPTION: {
                errorCollection.addErrorMessage(i18n.getText("admin.errors.custom.path", "<a id=\"reimport\" href=\"#\">", "</a>"));
                return false;
            }
            case DOWNGRADE_FROM_ONDEMAND: {
                errorCollection.addErrorMessage(i18n.getText("admin.errors.import.downgrade.error", importResult.getSpecificErrorMessage(), "<a id='acknowledgeDowngradeError' href='#'>", "</a>"));
                return false;
            }
            case FAILED_VALIDATION: {
                errorCollection.addErrorMessages((Collection)importResult.getValidationErrorMessages());
                return false;
            }
            case NONE: {
                return !importResult.getErrorCollection().hasAnyErrors() && this.checkLicenseIsInvalidOrTooOldForBuild();
            }
        }
        throw new UnsupportedOperationException("Unknown import error type " + importResult.getImportError());
    }

    private boolean checkLicenseIsInvalidOrTooOldForBuild() {
        return this.licenseJohnsonEventRaiser.checkLicense();
    }
}

