/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.services.export.ExportService;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraProductInformation;
import com.atlassian.jira.util.UrlValidator;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.bean.I18nBean;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SetupApplicationProperties
extends AbstractSetupAction {
    private String nextStep;
    private String title;
    private String baseURL;
    private String mode = "private";
    private String attachmentPath;
    private JiraHome jiraHome;
    private AttachmentPathManager.Mode attachmentMode = AttachmentPathManager.Mode.DEFAULT;
    private DirectoryMode backupMode = DirectoryMode.DEFAULT;
    private String indexPath;
    private final IssueIndexManager indexManager;
    private final ServiceManager serviceManager;
    private final IndexPathManager indexPathManager;
    private final AttachmentPathManager attachmentPathManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraWebResourceManager webResourceManager;

    public SetupApplicationProperties(IssueIndexManager indexManager, ServiceManager serviceManager, IndexPathManager indexPathManager, AttachmentPathManager attachmentPathManager, JiraHome jiraHome, BuildUtilsInfo buildUtilsInfo, FileFactory fileFactory, JiraWebResourceManager webResourceManager, JiraProperties jiraProperties, JiraProductInformation jiraProductInformation) {
        super(fileFactory, jiraProperties, jiraProductInformation);
        this.indexManager = indexManager;
        this.serviceManager = serviceManager;
        this.indexPathManager = indexPathManager;
        this.attachmentPathManager = attachmentPathManager;
        this.webResourceManager = webResourceManager;
        this.jiraHome = (JiraHome)Assertions.notNull((String)"jiraHome", (Object)jiraHome);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
    }

    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        ApplicationProperties applicationProperties = this.getApplicationProperties();
        this.title = applicationProperties.getString("jira.title");
        if (this.title == null) {
            this.title = applicationProperties.getDefaultString("jira.title");
            applicationProperties.setString("jira.title", this.title);
        }
        if (applicationProperties.getString("jira.baseurl") != null) {
            this.baseURL = applicationProperties.getString("jira.baseurl");
        }
        if (applicationProperties.getString("jira.mode") != null) {
            this.mode = applicationProperties.getString("jira.mode");
        }
        if (this.attachmentPathManager.getAttachmentPath() != null) {
            this.attachmentPath = this.attachmentPathManager.getAttachmentPath();
        }
        if (this.indexPathManager.getIndexRootPath() != null) {
            this.indexPath = this.indexPathManager.getIndexRootPath();
        }
        this.webResourceManager.putMetadata("version-number", this.buildUtilsInfo.getVersion());
        return "input";
    }

    protected void doValidation() {
        if (this.nextStep == null || this.setupAlready()) {
            return;
        }
        if (!TextUtils.stringSet((String)this.title)) {
            this.addError("title", this.getText("setup.error.specifytitle"));
        }
        if (!UrlValidator.isValid(this.baseURL)) {
            this.addError("baseURL", this.getText("setup.error.baseURL"));
        }
        if (!this.getAllowedModes().keySet().contains(this.mode)) {
            this.addError("mode", this.getText("setup.error.mode"));
        }
        super.doValidation();
    }

    protected String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (this.nextStep == null) {
            return "error";
        }
        this.getApplicationProperties().setString("jira.title", this.title);
        this.getApplicationProperties().setString("jira.baseurl", this.baseURL);
        this.getApplicationProperties().setString("jira.mode", this.mode);
        if (this.indexManager.isIndexAvailable()) {
            try {
                this.indexManager.deactivate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.indexManager.activate(Contexts.percentageLogger((Sized)this.indexManager, (Logger)this.log));
        }
        catch (Exception e) {
            this.log.error((Object)("Error activating indexing with path '" + this.indexPath + "': " + e), (Throwable)e);
            this.addError("indexPath", this.getText("setup.error.indexpath.activate_error", e.getMessage()));
        }
        if (this.attachmentMode == AttachmentPathManager.Mode.DISABLED) {
            this.getApplicationProperties().setOption("jira.option.allowattachments", false);
        } else {
            this.attachmentPathManager.setUseDefaultDirectory();
            this.getApplicationProperties().setOption("jira.option.allowattachments", true);
        }
        if (this.backupMode != DirectoryMode.DISABLED) {
            new BackupServiceHelper().createOrUpdateBackupService(new I18nBean(), this.getDefaultBackupPath());
        }
        return this.invalidInput() ? "error" : this.forceRedirect("SetupLicense!default.jspa");
    }

    public void setNextStep(String nextStep) {
        this.nextStep = nextStep;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getBaseURL() {
        if (this.baseURL == null) {
            this.baseURL = JiraUrl.constructBaseUrl((HttpServletRequest)this.request);
        }
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = StringUtils.stripEnd((String)StringUtils.strip((String)baseURL), (String)" /");
    }

    private Map<String, String> getAllowedModes() {
        HashMap<String, String> allowedModes = new HashMap<String, String>();
        allowedModes.put("public", "Public");
        allowedModes.put("private", "Private");
        return allowedModes;
    }

    public String getAttachmentPath() {
        return this.attachmentPath;
    }

    public String getAttachmentPathOption() {
        return this.attachmentMode.toString();
    }

    public void setAttachmentPathOption(String attachmentPathOption) {
        this.attachmentMode = AttachmentPathManager.Mode.valueOf((String)attachmentPathOption);
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public String getDefaultBackupPath() {
        return this.jiraHome.getExportDirectory().getPath();
    }

    public String getBackupPathOption() {
        return this.backupMode.toString();
    }

    public void setBackupPathOption(String backupPathOption) {
        this.backupMode = DirectoryMode.valueOf(backupPathOption);
    }

    public int modulo(int index, int modulus) {
        return index % modulus;
    }

    private final class BackupServiceHelper {
        private static final String SERVICE_NAME_KEY = "admin.setup.services.backup.service";
        private final long DELAY = DateUtils.HOUR_MILLIS * 12L;

        private BackupServiceHelper() {
        }

        public void createOrUpdateBackupService(I18nHelper i18n, String backupPath) {
            try {
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                params.put("USE_DEFAULT_DIRECTORY", new String[]{"true"});
                String serviceName = this.geti18nTextWithDefault(i18n, SERVICE_NAME_KEY, "Backup Service");
                if (SetupApplicationProperties.this.serviceManager.getServiceWithName(serviceName) == null) {
                    SetupApplicationProperties.this.serviceManager.addService(serviceName, ExportService.class.getName(), this.DELAY, params);
                } else {
                    SetupApplicationProperties.this.serviceManager.editServiceByName(serviceName, this.DELAY, params);
                }
                SetupApplicationProperties.this.getApplicationProperties().setString("jira.path.backup", backupPath);
            }
            catch (Exception e) {
                SetupApplicationProperties.this.log.error((Object)"Error creating backup service", (Throwable)e);
                SetupApplicationProperties.this.addErrorMessage(SetupApplicationProperties.this.getText("admin.errors.setup.error.adding.service", e.toString()));
            }
        }

        String geti18nTextWithDefault(I18nHelper i18n, String key, String defaultString) {
            String result = i18n.getText(key);
            if (key.equals(result)) {
                return defaultString;
            }
            return result;
        }
    }

    private static enum DirectoryMode {
        DEFAULT,
        DISABLED;

    }
}

