/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.RequestSourceType;
import com.atlassian.jira.web.action.project.ViewProject;
import com.google.common.base.Strings;
import java.net.URI;

public class EditProjectLeadAndDefaultAssignee
extends ViewProject {
    private final ProjectService projectService;
    private final AvatarService avatarService;
    private final UserManager userManager;
    private final UserSearchService userSearchService;
    private String leadError;
    private ApplicationUser leadUserObj;

    public EditProjectLeadAndDefaultAssignee(ProjectService projectService, AvatarService avatarService, UserManager userManager, UserSearchService userSearchService) {
        this.projectService = projectService;
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.userSearchService = userSearchService;
    }

    @Override
    public String doDefault() throws Exception {
        if (this.getProjectObject() == null) {
            return this.handleProjectDoesNotExist();
        }
        if (!this.hasProjectAdminPermission() && !this.hasAdminPermission()) {
            return "securitybreach";
        }
        this.setName(this.getProjectObject().getName());
        this.setAvatarId(this.getProjectObject().getAvatar() != null ? this.getProjectObject().getAvatar().getId() : null);
        this.setLead(this.getProjectObject().getLeadUserName());
        this.setUrl(this.getProjectObject().getUrl());
        this.setDescription(this.getProjectObject().getDescription());
        this.setAssigneeType(this.getProjectObject().getAssigneeType());
        return "input";
    }

    private String handleProjectDoesNotExist() throws Exception {
        if (this.hasAdminPermission()) {
            this.setName("???");
            this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
            return super.doDefault();
        }
        return "securitybreach";
    }

    @Override
    protected void doValidation() {
        if (this.getProjectObject() == null) {
            this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
            return;
        }
        ProjectService.UpdateProjectValidationResult result = this.validateProjectUpdate();
        if (!result.isValid()) {
            this.mapErrorCollection(result.getErrorCollection());
        }
        if (this.getLeadUserObj() == null) {
            this.setLeadError(this.getLead());
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (!this.hasProjectAdminPermission() && !this.hasAdminPermission()) {
            return "securitybreach";
        }
        Project projectObject = this.getProjectObject();
        ProjectService.UpdateProjectValidationResult result = this.validateProjectUpdate();
        this.projectService.updateProject(result);
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return this.getRedirect("/plugins/servlet/project-config/" + this.getProjectObject().getKey() + "/roles");
    }

    private ProjectService.UpdateProjectValidationResult validateProjectUpdate() {
        ProjectService.UpdateProjectRequest request = new ProjectService.UpdateProjectRequest(this.getProjectObject());
        request.leadUsername(Strings.nullToEmpty((String)this.getLead()));
        request.assigneeType(this.getAssigneeType());
        request.requestSourceType(this.isInlineDialogMode() ? RequestSourceType.DIALOG : RequestSourceType.PAGE);
        return this.projectService.validateUpdateProject(this.getLoggedInUser(), request);
    }

    public boolean userPickerDisabled() {
        return !this.userSearchService.canPerformAjaxSearch(this.getJiraServiceContext());
    }

    public ApplicationUser getLeadUserObj() {
        if (this.getLead() != null && this.leadUserObj == null) {
            this.leadUserObj = this.userManager.getUserByName(this.getLead());
        }
        return this.leadUserObj;
    }

    public URI getLeadUserAvatarUrl() {
        return this.avatarService.getAvatarURL(this.getLoggedInUser(), this.getLead(), Avatar.Size.SMALL);
    }

    public String getLeadError() {
        return this.leadError;
    }

    public void setLeadError(String leadError) {
        this.leadError = leadError;
    }
}

