/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationAction;
import com.atlassian.jira.web.bean.BulkEditBeanImpl;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.SimpleColumnLayoutItem;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class BulkEdit1
extends AbstractBulkOperationAction {
    private String reset;
    private long tempMax = -1L;
    private static final PagerFilter ALL_ISSUES_PAGER = PagerFilter.getUnlimitedFilter();
    private final SearchService searchService;
    private final IssueManager issueManager;
    private ApplicationProperties applicationProperties;
    private final BulkEditBeanSessionHelper bulkEditBeanSessionHelper;
    private String searchParent;
    private String searchMode;

    public BulkEdit1(SearchService searchService, IssueManager issueManager, ApplicationProperties applicationProperties, BulkEditBeanSessionHelper bulkEditBeanSessionHelper) {
        super(searchService, bulkEditBeanSessionHelper);
        this.searchService = searchService;
        this.issueManager = issueManager;
        this.applicationProperties = applicationProperties;
        this.bulkEditBeanSessionHelper = bulkEditBeanSessionHelper;
    }

    public String doDefault() throws Exception {
        if (this.getQuery() == null) {
            return this.getRedirect(this.getRedirectUrl());
        }
        if (this.isNewBulkEdit()) {
            this.initialiseBulkEditBean();
        }
        return super.doDefault();
    }

    private void initialiseBulkEditBean() throws SearchException {
        PagerFilter pager;
        BulkEditBeanImpl bulkEditBean = new BulkEditBeanImpl(this.issueManager);
        bulkEditBean.setIssuesInUse(bulkEditBean.getIssuesFromSearchRequest());
        Query query = this.getQuery();
        if (this.getTempMax() > -1L) {
            int max = (int)Math.min(Integer.MAX_VALUE, this.getTempMax());
            pager = new PagerFilter(max);
            bulkEditBean.setMaxIssues(max);
        } else {
            pager = (PagerFilter)this.getSessionPagerFilterManager().getCurrentObject();
            if (pager == null) {
                pager = new PagerFilter(PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.bulk.edit.limit.issue.count", (int)Integer.MAX_VALUE));
            }
        }
        List issues = this.searchService.search(this.getLoggedInUser(), query, pager).getResults();
        bulkEditBean.setIssuesFromSearchRequest(issues);
        this.storeBulkEditBean(bulkEditBean);
    }

    protected void doValidation() {
        if (this.getQuery() != null) {
            try {
                this.initialiseBulkEditBean();
            }
            catch (SearchException e) {
                this.log.error((Object)"Error occurred while initialising BulkEditBean.", (Throwable)e);
                this.addErrorMessage(this.getText("bulk.bean.initialise.error"));
                return;
            }
            this.getBulkEditBean().setParams(ActionContext.getParameters());
            List selectedIssues = this.getBulkEditBean().getSelectedIssues();
            if (!this.userHasPermissionToViewSelectedIssues()) {
                this.addErrorMessage(this.getText("bulk.edit.perform.invalid.action", ""));
                this.getBulkEditBean().setParams(new HashMap());
                return;
            }
            if (selectedIssues.isEmpty()) {
                this.addErrorMessage(this.getText("bulk.edit.you.must.select.at.least.one.issue"));
            } else {
                String maxIssuesString = this.getApplicationProperties().getDefaultBackedString("jira.bulk.edit.limit.issue.count");
                if (StringUtils.isNotEmpty((CharSequence)maxIssuesString)) {
                    try {
                        int maxIssues = Integer.parseInt(maxIssuesString);
                        if (maxIssues >= 0 && selectedIssues.size() > maxIssues) {
                            this.addErrorMessage(this.getText("bulk.edit.limit.issue.count.error", Integer.toString(maxIssues)));
                        }
                    }
                    catch (NumberFormatException e) {
                        this.log.error((Object)("Error parsing property 'jira.bulk.edit.limit.issue.count' = '" + maxIssuesString + "' as it is not a number. Ignoring property."), (Throwable)e);
                    }
                }
            }
        }
    }

    protected boolean userHasPermissionToViewSelectedIssues() {
        int SOFT_ISSUE_LIMIT = 50;
        List selectedIssues = this.getBulkEditBean().getSelectedIssues();
        for (List issuesChunk : Lists.partition((List)selectedIssues, (int)50)) {
            Query findAllSelectedIssues = JqlQueryBuilder.newClauseBuilder().issue((String[])issuesChunk.stream().map(Issue::getKey).toArray(String[]::new)).buildQuery();
            try {
                if (this.searchService.searchCount(this.getLoggedInUser(), findAllSelectedIssues) == (long)issuesChunk.size()) continue;
                return false;
            }
            catch (SearchException e) {
                this.log.error((Object)"Bulkedit Validation Failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public List getColumns() throws Exception {
        List columns = super.getColumns();
        columns.add(0, this.getCheckboxColumn());
        return columns;
    }

    private SimpleColumnLayoutItem getCheckboxColumn() {
        return new SimpleColumnLayoutItem(){

            @Override
            public String getHtml(Map displayParams, Issue issue) {
                String name = BulkEdit1.this.getBulkEditBean().getCheckboxName(issue);
                String checked = BulkEdit1.this.getBulkEditBean().isChecked(issue) ? "checked" : "";
                return String.format("<input type=\"checkbox\" name=\"%s\" %s />", name, checked);
            }

            @Override
            public String getHeaderHtml() {
                return "<input type='checkbox' id='bulkedit-select-all' name='all' value='on'>";
            }
        };
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.getQuery() == null) {
            return this.redirectToSessionTimeout();
        }
        this.getBulkEditBean().setCurrentStep(2);
        return this.getRedirect("BulkChooseOperation!default.jspa");
    }

    public String getCheckboxName(GenericValue issue) {
        return "bulkedit_" + issue.getLong("id");
    }

    public String getReset() {
        return this.reset;
    }

    public void setReset(String reset) {
        this.reset = reset;
    }

    private boolean isNewBulkEdit() {
        return "true".equals(this.getReset());
    }

    public void setCurrentStep(int step) {
        this.getBulkEditBean().setCurrentStep(step);
    }

    public long getTempMax() {
        return this.tempMax;
    }

    public void setTempMax(long tempMax) {
        this.tempMax = Math.min((long)PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.bulk.edit.limit.issue.count", (int)Integer.MAX_VALUE), tempMax);
    }

    public boolean isBulkLimited() {
        String maxBulkEdit = this.applicationProperties.getDefaultBackedString("jira.bulk.edit.limit.issue.count");
        if (maxBulkEdit != null) {
            try {
                int configuredMax = Integer.parseInt(maxBulkEdit);
                return this.tempMax >= (long)configuredMax;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    @Deprecated
    private String redirectToSessionTimeout() {
        ActionContext.getSession().put("jira.session.timeout.message", this.getText("bulk.edit.session.timeout.message"));
        return this.getRedirect("SessionTimeoutMessage.jspa");
    }

    private Query getQuery() {
        return Optional.ofNullable(this.getSearchParentQuery()).orElseGet(() -> this.getSearchRequest().getQuery());
    }

    private Query getSearchParentQuery() {
        if (StringUtils.isNotEmpty((CharSequence)this.getSearchParent())) {
            this.getSessionPagerFilterManager().setCurrentObject(null);
            JqlClauseBuilder jqlClauseBuilder = JqlQueryBuilder.newClauseBuilder().issueParent(new String[]{this.getSearchParent()}).and().issueTypeIsSubtask();
            if ("unresolved".equals(this.getSearchMode())) {
                jqlClauseBuilder.and().resolution().eq("Unresolved");
            }
            Clause clause = jqlClauseBuilder.buildClause();
            return new QueryImpl(clause, (OrderBy)new OrderByImpl(new SearchSort[0]), null);
        }
        return null;
    }

    public String getSearchParent() {
        return this.searchParent;
    }

    public void setSearchParent(String searchParent) {
        this.searchParent = searchParent;
    }

    public String getSearchMode() {
        return this.searchMode;
    }

    public void setSearchMode(String searchMode) {
        this.searchMode = searchMode;
    }
}

