/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.operation.BulkEditTaskContext;
import com.atlassian.jira.bulkedit.operation.ProgressAwareBulkOperation;
import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationAction;
import com.atlassian.jira.web.action.issue.bulkedit.BulkOperationProgress;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;

public abstract class AbstractBulkOperationDetailsAction
extends AbstractBulkOperationAction {
    private final TaskManager taskManager;
    private final I18nHelper i18nHelper;

    public AbstractBulkOperationDetailsAction(SearchService searchService, BulkEditBeanSessionHelper bulkEditBeanSessionHelper, TaskManager taskManager, I18nHelper i18nHelper) {
        super(searchService, bulkEditBeanSessionHelper);
        this.taskManager = taskManager;
        this.i18nHelper = i18nHelper;
    }

    public abstract String doDetails() throws Exception;

    public abstract String doDetailsValidation() throws Exception;

    public abstract String doPerform() throws Exception;

    protected String submitBulkOperationTask(BulkEditBean bulkEditBean, ProgressAwareBulkOperation operation, String taskName, SpanningOperation spanningOperation) throws Exception {
        String operationName;
        String username = this.getLoggedInUser().getUsername();
        BulkEditTaskContext context = new BulkEditTaskContext(username, operationName = operation.getOperationName());
        TaskDescriptor taskDescriptor = this.taskManager.getLiveTask(context);
        if (taskDescriptor != null) {
            this.log.debug((Object)("An existing task found for " + context + ", not starting another one."));
            return this.getRedirect(taskDescriptor.getProgressURL());
        }
        this.log.debug((Object)("Submitting a new task with task manager: " + context));
        BulkOperationProgress.BulkEditCallable bulkeditCallable = new BulkOperationProgress.BulkEditCallable(this.log, this.i18nHelper, operation, bulkEditBean, this.getLoggedInUser());
        String progressUrl = this.taskManager.submitTask(bulkeditCallable, taskName, context, false, spanningOperation).getProgressURL();
        return this.watchProgress(progressUrl);
    }
}

