/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.issue.archiving.ArchivedIssueService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.issue.AbstractViewIssue;
import java.util.Collection;

public class RestoreIssue
extends AbstractViewIssue {
    private boolean confirm;
    private final ArchivedIssueService archivedIssueService;
    private ArchivedIssueService.ValidationResult validationResult;
    private Integer numberOfSubTasks;

    public RestoreIssue(SubTaskManager subTaskManager, ArchivedIssueService archivedIssueService, HelpUrls helpUrls) {
        super(subTaskManager);
        this.archivedIssueService = archivedIssueService;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ArchivedIssueService.ArchivingResult archivingResult;
        if (this.confirm && !(archivingResult = this.archivedIssueService.restoreIssue(this.validationResult)).isValid()) {
            this.addErrorCollection(archivingResult.getErrorCollection());
            return "error";
        }
        return this.returnComplete(this.getViewUrl());
    }

    protected void doValidation() {
        this.validationResult = this.archivedIssueService.validateRestoreIssue(this.getLoggedInUser(), this.getKey());
        if (!this.validationResult.isValid()) {
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
    }

    public String doDefault() throws Exception {
        this.doValidation();
        return "input";
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    @ActionViewData
    public Integer getNumberOfSubTasks() {
        if (this.numberOfSubTasks == null) {
            this.numberOfSubTasks = this.getIssueObject().getSubTaskObjects().size();
        }
        return this.numberOfSubTasks;
    }

    @ActionViewData
    public String getTargetUrl() {
        return this.getViewUrl();
    }

    @Override
    @ActionViewData
    public String getIssuePath() {
        return super.getIssuePath();
    }

    @ActionViewData
    public boolean hasAnyErrors() {
        return super.hasAnyErrors();
    }

    @ActionViewData
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    @Override
    @ActionViewData
    public String getKey() {
        return super.getKey();
    }

    @ActionViewData
    public String getXsrfToken() {
        return super.getXsrfToken();
    }
}

