/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.movesubtask.MoveSubTaskOperationManager;
import com.atlassian.jira.movesubtask.operation.MoveSubTaskOperation;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.MoveIssue;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class MoveSubTaskParent
extends MoveIssue {
    private MoveSubTaskOperation moveSubTaskOperation;
    private final IssueUpdater issueUpdater;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private String parentIssue;
    private static final String FIELD_PARENT_ISSUE = "parentIssue";

    public MoveSubTaskParent(MoveSubTaskOperationManager moveSubTaskOperationManager, SubTaskManager subTaskManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, IssueUpdater issueUpdater, CommentService commentService, IssueTypeSchemeManager issueTypeSchemeManager, UserUtil userUtil) {
        super(subTaskManager, constantsManager, workflowManager, fieldManager, fieldLayoutManager, issueFactory, fieldScreenRendererFactory, commentService, userUtil);
        this.issueUpdater = issueUpdater;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.moveSubTaskOperation = moveSubTaskOperationManager.getOperation("move.subtask.parent.operation.name");
    }

    public MoveSubTaskOperation getMoveSubTaskOperation() {
        return this.moveSubTaskOperation;
    }

    public Collection getSubTaskTypes() {
        return this.issueTypeSchemeManager.getSubTaskIssueTypesForProject(this.getIssueObject().getProjectObject());
    }

    @Override
    public String doDefault() {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        if (this.getMoveIssueBean() != null) {
            this.getMoveIssueBean().setCurrentStep(3);
            this.getMoveIssueBean().addAvailablePreviousStep(0);
        }
        return "input";
    }

    @Override
    protected void doValidation() {
        if (this.getMoveIssueBean() != null) {
            Issue currentIssue;
            try {
                currentIssue = this.getIssueObject();
            }
            catch (IssueNotFoundException e) {
                return;
            }
            catch (IssuePermissionException e) {
                return;
            }
            catch (Exception e) {
                this.addErrorMessage(this.getText("error.unexpected.condition", e.getMessage()));
                return;
            }
            if (!this.hasIssuePermission(ProjectPermissions.MOVE_ISSUES, currentIssue)) {
                this.addErrorMessage(this.getText("move.issue.nopermissions"));
                return;
            }
            if (!TextUtils.stringSet((String)this.getParentIssue())) {
                this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.issue.required"));
                return;
            }
            Issue oldParentIssue = currentIssue.getParentObject();
            Issue newParentIssue = this.getNewParentIssue();
            if (newParentIssue == null) {
                this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.cannotlink.issue.notexist", this.getParentIssue()));
            } else {
                if (oldParentIssue.equals((Object)newParentIssue)) {
                    this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.cannotlink.current.parent"));
                } else if (!oldParentIssue.getProjectId().equals(newParentIssue.getProjectId())) {
                    this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.cannotlink.different.project"));
                }
                if (this.getSubTaskManager().isSubTask(newParentIssue)) {
                    if (newParentIssue.equals((Object)currentIssue)) {
                        this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.cannotlink.itself"));
                    } else {
                        this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.cannotlink.subtask"));
                    }
                }
                if (!newParentIssue.isEditable()) {
                    this.addError(FIELD_PARENT_ISSUE, this.getText("move.subtask.parent.error.parentnoteditable", this.getParentIssue()));
                }
            }
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws RemoveException, CreateException {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        Issue subTask = this.getIssueObject();
        Issue parentIssue = this.getNewParentIssue();
        IssueUpdateBean iub = this.getSubTaskManager().changeParent(subTask, parentIssue, this.getLoggedInUser());
        this.issueUpdater.doUpdate(iub, true);
        return this.getRedirect("/browse/" + StringUtils.trim((String)this.getIssue().getString("key")));
    }

    private Issue getNewParentIssue() {
        String newParentIssueId = this.getParentIssue();
        return this.getIssueManager().getIssueObject(newParentIssueId);
    }

    @Override
    public MutableIssue getIssueObject(GenericValue issue) {
        MutableIssue issueObject = super.getIssueObject(issue);
        issueObject.setParentId(this.getSubTaskManager().getParentIssueId(this.getIssueObject()));
        return issueObject;
    }

    public String getCurrentPid() {
        return this.getProjectObject() != null && this.getProjectObject().getId() != null ? this.getProjectObject().getId().toString() : null;
    }

    public String getParentIssue() {
        return this.parentIssue;
    }

    public void setParentIssue(String parentIssue) {
        this.parentIssue = parentIssue;
    }

    public String getParentKey() {
        Issue parent = this.getIssueObject().getParentObject();
        if (parent != null) {
            return parent.getKey();
        }
        return null;
    }
}

