/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.event.issue.link.RemoteIssueLinkUIDeleteEvent;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;

public class DeleteRemoteIssueLink
extends AbstractIssueSelectAction {
    private final RemoteIssueLinkService remoteIssueLinkService;
    private final EventPublisher eventPublisher;
    private RemoteIssueLink remoteIssueLink;
    private RemoteIssueLinkService.DeleteValidationResult deleteValidationResult;
    private boolean confirm;
    private Long remoteIssueLinkId;

    public DeleteRemoteIssueLink(RemoteIssueLinkService remoteIssueLinkService, EventPublisher eventPublisher) {
        this.remoteIssueLinkService = remoteIssueLinkService;
        this.eventPublisher = eventPublisher;
    }

    protected void doValidation() {
        try {
            if (!this.hasIssuePermission(ProjectPermissions.LINK_ISSUES, this.getIssueObject())) {
                this.addErrorMessage(this.getText("admin.errors.issues.no.permission.to.delete.links"));
                return;
            }
            this.deleteValidationResult = this.remoteIssueLinkService.validateDelete(this.getLoggedInUser(), this.remoteIssueLinkId);
            if (!this.deleteValidationResult.isValid()) {
                this.addErrorMessages(this.deleteValidationResult.getErrorCollection().getErrorMessages());
                for (String error : this.deleteValidationResult.getErrorCollection().getErrors().values()) {
                    this.addErrorMessage(error);
                }
            } else {
                RemoteIssueLinkService.RemoteIssueLinkResult remoteIssueLinkResult = this.remoteIssueLinkService.getRemoteIssueLink(this.getLoggedInUser(), this.remoteIssueLinkId);
                if (remoteIssueLinkResult.getErrorCollection().hasAnyErrors()) {
                    this.addErrorMessages(remoteIssueLinkResult.getErrorCollection().getErrorMessages());
                } else {
                    this.remoteIssueLink = remoteIssueLinkResult.getRemoteIssueLink();
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Exception: " + e), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.issues.exception.occured.validating", e));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.confirm) {
            this.remoteIssueLinkService.delete(this.getLoggedInUser(), this.deleteValidationResult);
            this.eventPublisher.publish((Object)new RemoteIssueLinkUIDeleteEvent(this.deleteValidationResult.getRemoteIssueLinkId()));
            boolean hasRemoteIssueLinks = this.remoteIssueLinkService.getRemoteIssueLinksForIssue(this.getLoggedInUser(), this.getIssueObject()).getRemoteIssueLinks().iterator().hasNext();
            String targetID = hasRemoteIssueLinks ? "#linkingmodule" : "";
            String redirectUrl = "/browse/" + this.getIssueObject().getKey() + targetID;
            if (this.isInlineDialogMode()) {
                return this.returnCompleteWithInlineRedirect(redirectUrl);
            }
            return this.returnComplete(redirectUrl);
        }
        return "input";
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public Long getRemoteIssueLinkId() {
        return this.remoteIssueLinkId;
    }

    public void setRemoteIssueLinkId(Long remoteIssueLinkId) {
        this.remoteIssueLinkId = remoteIssueLinkId;
    }

    public String getRelationship() {
        return this.remoteIssueLink == null ? null : this.remoteIssueLink.getRelationship();
    }

    public String getLinkTitle() {
        return this.remoteIssueLink == null ? null : this.remoteIssueLink.getTitle();
    }

    public boolean isRemoteIssueLink() {
        return true;
    }
}

