/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.AbstractCommentableAssignableIssue;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import webwork.action.ActionContext;

public class AssignIssue
extends AbstractCommentableAssignableIssue
implements OperationContext {
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final FieldLayoutManager fieldLayoutManager;
    private final FieldManager fieldManager;
    private final IssueManager issueManager;
    private FieldScreenRenderer fieldScreenRenderer;
    private long maxSize = Long.MIN_VALUE;

    public AssignIssue(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldLayoutManager fieldLayoutManager, FieldManager fieldManager, CommentService commentService, IssueManager issueManager, UserUtil userUtil) {
        super(subTaskManager, fieldScreenRendererFactory, commentService, userUtil);
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldManager = fieldManager;
        this.issueManager = issueManager;
    }

    @Override
    public String doDefault() throws Exception {
        try {
            for (FieldScreenRenderTab fieldScreenRenderTab : this.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
                for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                    if (!fieldScreenRenderLayoutItem.isShow(this.getIssueObject())) continue;
                    fieldScreenRenderLayoutItem.populateFromIssue(this.getFieldValuesHolder(), this.getIssueObject());
                }
            }
            return super.doDefault();
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
    }

    @Override
    public void doValidation() {
        try {
            this.doCommentValidation(true);
            OrderableField field = (OrderableField)this.fieldManager.getField("assignee");
            field.populateFromParams(this.getFieldValuesHolder(), ActionContext.getParameters());
            field.validateParams((OperationContext)this, (ErrorCollection)this, (I18nHelper)this, this.getIssueObject(), this.getFieldScreenRendererLayoutItemForField(field));
            if (!this.issueManager.isEditable(this.getIssueObject())) {
                this.addErrorMessage(this.getText("editissue.error.no.edit.workflow"));
            }
            if (!TextUtils.stringSet((String)this.getAssignee())) {
                if (!TextUtils.stringSet((String)this.getIssue().getString("assignee"))) {
                    this.addError("assignee", this.getText("assign.error.alreadyunassigned"));
                }
            } else {
                ApplicationUser currentAssignee = this.userUtil.getUserByKey(this.getIssue().getString("assignee"));
                if (currentAssignee != null && this.getAssignee().equals(currentAssignee.getUsername())) {
                    this.addError("assignee", this.getText("assign.error.alreadyassigned", EasyList.build((Object)currentAssignee.getDisplayName(), (Object)currentAssignee.getUsername())));
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            this.addError("assignee", this.getText("assign.error.userdoesnotexist", this.getAssignee()));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        MutableIssue issue = this.getMutableIssue();
        OrderableField field = (OrderableField)this.fieldManager.getField("assignee");
        FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout((Issue)issue).getFieldLayoutItem(field);
        field.updateIssue(fieldLayoutItem, issue, this.getFieldValuesHolder());
        this.processAttachments(issue);
        OrderableField commentField = (OrderableField)this.fieldManager.getField("comment");
        FieldLayoutItem fieldLayoutItem2 = this.fieldLayoutManager.getFieldLayout(issue.getProjectObject(), issue.getIssueTypeId()).getFieldLayoutItem(commentField);
        commentField.updateIssue(fieldLayoutItem2, issue, this.getFieldValuesHolder());
        this.issueManager.updateIssue(this.getLoggedInUser(), issue, EventDispatchOption.ISSUE_ASSIGNED, true);
        if (this.isInlineDialogMode()) {
            return this.returnComplete();
        }
        return this.getRedirect("/browse/" + issue.getKey());
    }

    protected FieldScreenRenderer getFieldScreenRenderer() {
        if (this.fieldScreenRenderer == null) {
            this.fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(this.getIssueObject(), (IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION);
        }
        return this.fieldScreenRenderer;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

