/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.base.MoreObjects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractWorkflowAction
extends JiraWebActionSupport {
    protected final JiraWorkflow workflow;
    private Long project;
    private String issueType;
    private String descriptorTab;

    public AbstractWorkflowAction(JiraWorkflow workflow) {
        this.workflow = workflow;
    }

    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }

    public Long getProject() {
        return this.project;
    }

    public void setProject(Long project) {
        this.project = project;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = StringUtils.stripToNull((String)issueType);
    }

    public static String getFullModuleKey(String pluginKey, String moduleKey) {
        if (pluginKey == null && moduleKey == null) {
            return "";
        }
        return pluginKey + (String)MoreObjects.firstNonNull((Object)moduleKey, (Object)"");
    }

    protected String getBasicWorkflowParameters() {
        StringBuilder paramBuilder = new StringBuilder("?workflowName=").append(JiraUrlCodec.encode((String)this.getWorkflow().getName())).append("&workflowMode=").append(this.getWorkflow().getMode());
        if (this.getProject() != null) {
            paramBuilder.append("&project=").append(this.getProject());
        }
        if (this.getIssueType() != null) {
            paramBuilder.append("&issueType=").append(JiraUrlCodec.encode((String)this.getIssueType()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDescriptorTab())) {
            paramBuilder.append("&descriptorTab=").append(JiraUrlCodec.encode((String)this.getDescriptorTab()));
        }
        return paramBuilder.toString();
    }

    public String getDescriptorTab() {
        return this.descriptorTab;
    }

    public void setDescriptorTab(String descriptorTab) {
        this.descriptorTab = descriptorTab;
    }

    public String getWorkflowDisplayName() {
        return WorkflowUtil.getWorkflowDisplayName((JiraWorkflow)this.workflow);
    }
}

