/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class ResetFailedLoginCount
extends JiraWebActionSupport {
    private final UserManager userManager;
    private final LoginService loginService;
    private String name;
    private ApplicationUser user;

    public ResetFailedLoginCount(UserManager userManager, LoginService loginService) {
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
        this.loginService = (LoginService)Assertions.notNull((String)"loginService", (Object)loginService);
    }

    protected void doValidation() {
        this.user = this.userManager.getUser(this.name);
        if (this.user == null) {
            this.addError("userName", this.getText("admin.resetfailedlogin.unknown.user", this.name));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.loginService.resetFailedLoginCount(this.user);
        String returnUrl = this.getReturnUrl();
        if (StringUtils.isBlank((CharSequence)returnUrl)) {
            returnUrl = "secure/admin/user/UserBrowser.jspa";
        }
        returnUrl = this.addNameParameter(returnUrl);
        this.setReturnUrl(returnUrl);
        return this.getRedirect(returnUrl);
    }

    private String addNameParameter(String returnUrl) {
        StringBuilder sb = new StringBuilder(returnUrl);
        if (returnUrl.indexOf("?") == -1) {
            sb.append("?");
        } else {
            sb.append("&");
        }
        sb.append("name=").append(this.name);
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

