/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.runtime.GroupNotFoundException;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.user.CreateUserApplicationHelper;
import com.atlassian.jira.bc.user.UserApplicationHelper;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.event.web.action.admin.UserAddedEvent;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserDetails;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.user.UserBrowser;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.net.UrlEscapers;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
public class AddUser
extends JiraWebActionSupport {
    private static final Logger log = LoggerFactory.getLogger(AddUser.class);
    private static final String ADD_USER_COUNT_EXTENSION_WEB_PANEL_LOCATION = "webpanels.admin.adduser.count";
    private static final String ADD_USER_EXTENSION_WEB_PANEL_LOCATION = "webpanels.admin.adduser";
    @VisibleForTesting
    static final String APPLICATION_ACCESS_EXTENSION_WEB_PANEL_LOCATION = "webpanels.admin.adduser.applicationaccess";
    private final UserService userService;
    private final UserManager userManager;
    private final WebInterfaceManager webInterfaceManager;
    private final EventPublisher eventPublisher;
    private final CreateUserApplicationHelper applicationHelper;
    private final ApplicationRoleManager roleManager;
    private String username;
    private String password;
    private String fullname;
    private String email;
    private Long directoryId;
    private boolean sendEmail = false;
    private boolean createAnother = false;
    private UserService.CreateUserValidationResult result;
    private List<String> passwordErrors = ImmutableList.of();
    private String[] selectedApplications;
    private String[] createdUser;
    private static final Function<String, String> SAFE_CREATED_USER_PARAM = s -> "createdUser=" + UrlEscapers.urlFormParameterEscaper().escape(s);

    public AddUser(UserService userService, UserManager userManager, WebInterfaceManager webInterfaceManager, EventPublisher eventPublisher, CreateUserApplicationHelper applicationHelper, ApplicationRoleManager roleManager) {
        this.userService = userService;
        this.userManager = userManager;
        this.webInterfaceManager = webInterfaceManager;
        this.eventPublisher = eventPublisher;
        this.applicationHelper = applicationHelper;
        this.roleManager = roleManager;
    }

    public String doDefault() {
        if (this.selectedApplications == null) {
            this.selectedApplications = (String[])this.roleManager.getDefaultApplicationKeys().stream().map(ApplicationKey::toString).toArray(String[]::new);
            List<UserApplicationHelper.ApplicationSelection> selectableApplications = this.getSelectableApplications();
            if (this.selectedApplications.length == 0 && selectableApplications.size() == 1 && ((UserApplicationHelper.ApplicationSelection)selectableApplications.iterator().next()).isSelectable()) {
                this.selectedApplications = (String[])selectableApplications.stream().map(UserApplicationHelper.ApplicationSelection::getKey).toArray(String[]::new);
            }
        }
        return "input";
    }

    protected void doValidation() {
        UserService.CreateUserRequest createUserRequest = UserService.CreateUserRequest.withUserDetails((ApplicationUser)this.getLoggedInUser(), (String)this.getUsername(), (String)this.getPassword(), (String)this.getEmail(), (String)this.getFullname()).inDirectory(this.getDirectoryId()).withApplicationAccess(this.getSelectedApplicationKeys()).sendNotification(this.sendEmail);
        this.result = this.userService.validateCreateUser(createUserRequest);
        if (!this.result.isValid()) {
            this.addErrorCollection(this.result.getErrorCollection());
        }
        this.passwordErrors = this.result.getPasswordErrors().stream().map(er -> er.getSnippet()).collect(Collectors.toList());
    }

    @RequiresXsrfCheck
    protected String doExecute() {
        try {
            this.userService.createUser(this.result);
            this.eventPublisher.publish((Object)new UserAddedEvent(this.request.getParameterMap()));
        }
        catch (PermissionException e) {
            this.addError("username", this.getText("admin.errors.user.no.permission.to.create"));
        }
        catch (CreateException e) {
            this.addError("username", this.getText("admin.errors.user.cannot.create", e.getMessage()));
        }
        catch (GroupNotFoundException e) {
            String directoryName = this.userManager.getDirectory(this.getDirectoryId()).getName();
            log.warn("Error occurred while adding user to group, the directory {} may be out of sync.", (Object)directoryName, (Object)e);
            String warningMessage = StringEscapeUtils.escapeHtml4((String)this.getText("admin.warn.user.create.no.group", this.getUsername(), e.getMessage(), directoryName));
            return this.returnCompleteWithInlineRedirectAndMsg(this.viewUserUrl(), warningMessage, JiraWebActionSupport.MessageType.WARNING, true, null);
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        if (this.createAnother) {
            return this.returnCompleteWithInlineRedirect(this.addUserUrl());
        }
        return this.returnCompleteWithInlineRedirect(this.userBrowserUrl());
    }

    private String addUserUrl() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)"createAnother=true");
        if (this.sendEmail) {
            builder.add((Object)"sendEmail=true");
        }
        if (this.selectedApplications != null && this.selectedApplications.length > 0) {
            Arrays.stream(this.selectedApplications).forEach(appKey -> builder.add((Object)("application=" + appKey)));
        } else {
            builder.add((Object)"application=");
        }
        if (this.getDirectories().size() > 1) {
            builder.add((Object)("directoryId=" + this.directoryId));
        }
        builder.addAll(this.createdUsersWithCurrentUser());
        return String.format("AddUser!default.jspa?%s", Joiner.on((String)"&").join((Iterable)builder.build()));
    }

    private String viewUserUrl() {
        return "ViewUser.jspa?name=" + JiraUrlCodec.encode((String)this.username.toLowerCase());
    }

    private String userBrowserUrl() {
        return UserBrowser.getActionUrl(Optional.of(Joiner.on((String)"&").join(this.createdUsersWithCurrentUser())), Optional.of("userCreatedFlag"));
    }

    @VisibleForTesting
    protected List<String> createdUsers() {
        if (this.createdUser == null) {
            return ImmutableList.of();
        }
        return (List)Arrays.stream(this.createdUser).map(SAFE_CREATED_USER_PARAM).collect(CollectorsUtil.toImmutableList());
    }

    private List<String> createdUsersWithCurrentUser() {
        return (List)Stream.concat(this.createdUsers().stream(), Stream.of(SAFE_CREATED_USER_PARAM.apply(this.getUsername()))).collect(CollectorsUtil.toImmutableList());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = StringUtils.trim((String)username);
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = StringUtils.trim((String)email);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = StringUtils.isEmpty((CharSequence)password) ? null : password;
    }

    public List<String> getPasswordErrors() {
        return this.passwordErrors;
    }

    public boolean hasPasswordWritableDirectory() {
        return this.userManager.hasPasswordWritableDirectory();
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public boolean isCreateAnother() {
        return this.createAnother;
    }

    public void setCreateAnother(boolean createAnother) {
        this.createAnother = createAnother;
    }

    public Long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(Long directoryId) {
        this.directoryId = directoryId;
    }

    public List<Directory> getDirectories() {
        return this.userManager.getWritableDirectories();
    }

    public String getCancelUrl() {
        return UserBrowser.getActionUrl(Optional.of(Joiner.on((String)"&").join(this.createdUsers())), this.createdUsers().isEmpty() ? Optional.empty() : Optional.of("userCreatedFlag"));
    }

    public Map<Long, Boolean> getCanDirectoryUpdatePasswordMap() {
        List<Directory> directories = this.getDirectories();
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(directories.size());
        for (Directory directory : directories) {
            result.put(directory.getId(), this.userManager.canDirectoryUpdateUserPassword(directory));
        }
        return result;
    }

    public String getUserCountWebPanelHtml() {
        return this.getPanels(ADD_USER_COUNT_EXTENSION_WEB_PANEL_LOCATION);
    }

    public String getWebPanelHtml() {
        return this.getPanels(ADD_USER_EXTENSION_WEB_PANEL_LOCATION);
    }

    public String getApplicationAccessWebPanelHtml() {
        return this.getPanels(APPLICATION_ACCESS_EXTENSION_WEB_PANEL_LOCATION);
    }

    private String getPanels(String panelLocation) {
        StringBuilder builder = new StringBuilder();
        List panels = this.webInterfaceManager.getDisplayableWebPanelDescriptors(panelLocation, Collections.emptyMap());
        for (final WebPanelModuleDescriptor panel : panels) {
            Option fragment = Option.option((Object)SafePluginPointAccess.call((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    if (panel == null || panel.getModule() == null) {
                        return null;
                    }
                    return ((WebPanel)panel.getModule()).getHtml(Collections.emptyMap());
                }
            }).getOrNull());
            if (!fragment.isDefined()) continue;
            builder.append((String)fragment.get());
        }
        return builder.toString();
    }

    public String[] getSelectedApplications() {
        return this.selectedApplications;
    }

    public void setSelectedApplications(String[] selectedApplications) {
        this.selectedApplications = selectedApplications;
    }

    public boolean getHasCreatedUsers() {
        return this.createdUser != null && this.createdUser.length > 0;
    }

    public String[] getCreatedUser() {
        return this.createdUser;
    }

    public void setCreatedUser(String[] createdUser) {
        this.createdUser = createdUser;
    }

    @Nonnull
    public Set<ApplicationKey> getSelectedApplicationKeys() {
        HashSet applicationKeys = Sets.newHashSet();
        if (this.selectedApplications != null) {
            for (String selectedApplication : this.selectedApplications) {
                applicationKeys.add(ApplicationKey.valueOf((String)selectedApplication));
            }
        }
        return ImmutableSet.copyOf((Collection)applicationKeys);
    }

    public boolean hasOnlyOneApplication() {
        int extraApplicationCount;
        int jiraApplicationCount = this.roleManager.getRoles().size();
        return jiraApplicationCount + (extraApplicationCount = this.webInterfaceManager.getDisplayableWebPanelDescriptors(APPLICATION_ACCESS_EXTENSION_WEB_PANEL_LOCATION, Collections.emptyMap()).size()) == 1;
    }

    @Nonnull
    public List<UserApplicationHelper.ApplicationSelection> getSelectableApplications() {
        Set<ApplicationKey> selectedKeys = this.getApplicationKeyObjects(this.selectedApplications);
        ImmutableSet applicationKeys = ImmutableSet.builder().addAll(selectedKeys).build();
        Optional<Long> directoryId = this.userManager.getDefaultCreateDirectory().map(Directory::getId);
        return this.applicationHelper.getApplicationsForSelection((Set<ApplicationKey>)applicationKeys, directoryId);
    }

    private Set<ApplicationKey> getApplicationKeyObjects(String[] applicationKeys) {
        if (applicationKeys == null) {
            return ImmutableSet.of();
        }
        return (Set)Arrays.stream(applicationKeys).map(ApplicationKey::valueOf).collect(CollectorsUtil.toImmutableSet());
    }

    private UserDetails toApplicationUserCreationData() {
        return new UserDetails(this.getUsername(), this.getFullname()).withDirectory(this.getDirectoryId()).withPassword(this.getPassword()).withEmail(this.getEmail());
    }
}

