/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.PrioritySchemeHelper;
import com.atlassian.jira.issue.priority.PrioritySchemeMigrateRequestHelper;
import com.atlassian.jira.issue.priority.PrioritySchemeMigratorFinder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.admin.priorities.ConfigurePriorityScheme;
import com.atlassian.jira.web.action.admin.priorities.PriorityManageableOption;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@WebSudoRequired
public class EditPriorityScheme
extends ConfigurePriorityScheme {
    private final PrioritySchemeMigratorFinder prioritySchemeMigratorFinder;
    private final PrioritySchemeMigrateRequestHelper prioritySchemeMigrateRequestHelper;

    public EditPriorityScheme(FieldConfigSchemeManager configSchemeManager, FieldManager fieldManager, PriorityManageableOption priorityManageableOption, PrioritySchemeManager prioritySchemeManager, PriorityManager priorityManager, PageBuilderService pageBuilderService, PrioritySchemeService prioritySchemeService, PrioritySchemeMigratorFinder prioritySchemeMigratorFinder, PrioritySchemeMigrateRequestHelper prioritySchemeMigrateRequestHelper, I18nHelper i18nHelper, PrioritySchemeHelper prioritySchemeHelper) {
        super(configSchemeManager, fieldManager, priorityManageableOption, prioritySchemeManager, priorityManager, pageBuilderService, prioritySchemeService, i18nHelper, prioritySchemeHelper);
        this.prioritySchemeMigratorFinder = prioritySchemeMigratorFinder;
        this.prioritySchemeMigrateRequestHelper = prioritySchemeMigrateRequestHelper;
    }

    @Override
    public String doDefault() throws Exception {
        FieldConfigScheme configScheme = this.getConfigScheme();
        if (configScheme != null) {
            this.setName(configScheme.getName());
            this.setDescription(configScheme.getDescription());
            this.setSelectedPriorities(this.getPrioritiesInScheme());
            String defaultPriority = this.prioritySchemeManager.getDefaultOption(this.getConfig());
            if (defaultPriority != null) {
                this.setDefaultPriority(defaultPriority);
            }
        }
        this.doValidation();
        return super.doDefault();
    }

    @Override
    protected void doValidation() {
        FieldConfigScheme configScheme = this.getConfigScheme();
        if (Objects.isNull(configScheme)) {
            this.processResources();
            this.addErrorMessage(this.getText("admin.common.errors.does.not.exist", this.getText("common.concepts.priorityscheme").toLowerCase(), ""));
        } else {
            super.doValidation();
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        FieldConfigScheme configSchemeForUpdate = new FieldConfigScheme.Builder(this.getConfigScheme()).setName(this.name).setDescription(this.description).toFieldConfigScheme();
        ServiceOutcome<FieldConfigScheme> serviceResult = this.prioritySchemeService.editScheme(this.getLoggedInUser(), configSchemeForUpdate, Arrays.asList(this.selectedPriorities), this.defaultPriority);
        this.addErrorCollection(serviceResult.getErrorCollection());
        return super.doExecute();
    }

    @Override
    public String getRedirect() {
        Optional<String> migrationRedirect = this.migrationNeeded();
        if (migrationRedirect.isPresent()) {
            return migrationRedirect.get();
        }
        return super.getRedirect();
    }

    private Optional<String> migrationNeeded() {
        List affectedProjects;
        List associatedProjects = this.getConfigScheme().getAssociatedProjectObjects();
        if (!associatedProjects.isEmpty() && (affectedProjects = associatedProjects.stream().filter(project -> this.prioritySchemeMigratorFinder.findUnmappedPriorities((Project)project, this.getConfigScheme()).size() > 0).collect(Collectors.toList())).size() > 0) {
            return Optional.of(this.getRedirect(this.getMigrationUrl(affectedProjects.stream().map(Project::getId).collect(Collectors.toList()))));
        }
        return Optional.empty();
    }

    private String getMigrationUrl(Collection<Long> affectedProjects) {
        this.prioritySchemeMigrateRequestHelper.storeMigratePrioritySchemeRequest(new PrioritySchemeMigrateRequestHelper.MigratePrioritySchemeRequest(affectedProjects, this.getSchemeId(), true));
        return "MigratePriorityScheme!default.jspa";
    }
}

