/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.Colours;
import com.atlassian.jira.web.action.admin.constants.AbstractEditConstant;
import com.atlassian.jira.web.action.admin.priorities.AddOrEditPriorityAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class EditPriority
extends AbstractEditConstant<Priority>
implements AddOrEditPriorityAction {
    private boolean preview = false;
    private String statusColor;
    private final PriorityManager priorityManager;
    private final PageBuilderService pageBuilderService;

    public EditPriority(PriorityManager priorityManager, PageBuilderService pageBuilderService) {
        this.priorityManager = priorityManager;
        this.pageBuilderService = pageBuilderService;
    }

    private void requireResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:view-priorities");
    }

    @Override
    public String doDefault() throws Exception {
        this.setStatusColor(((Priority)this.getConstant()).getStatusColor());
        this.requireResources();
        return super.doDefault();
    }

    @Override
    protected void doValidation() {
        this.requireResources();
        if (!this.isPreview()) {
            if (StringUtils.isBlank((CharSequence)this.getIconurl())) {
                this.addError("iconurl", this.getText("admin.errors.must.specify.url.for.icon"));
            }
            if (StringUtils.isBlank((CharSequence)this.getStatusColor())) {
                this.addError("statusColor", this.getText("admin.errors.must.specify.priority.color"));
            } else if (!Colours.isHexColour(this.getStatusColor())) {
                this.addError("statusColor", this.getText("admin.errors.must.specify.priority.color.as.hex.value"));
            }
            super.doValidation();
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.isPreview()) {
            return "input";
        }
        Priority priority = this.priorityManager.getPriority(this.id);
        this.priorityManager.editPriority(priority, this.name, this.description, this.iconurl, this.statusColor);
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect(this.getRedirectPage());
    }

    @Override
    protected String getConstantEntityName() {
        return "Priority";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.priority.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "priority";
    }

    @Override
    protected Priority getConstant(String id) {
        return this.getConstantsManager().getPriorityObject(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewPriorities.jspa";
    }

    @Override
    protected Collection<Priority> getConstants() {
        return this.getConstantsManager().getPriorityObjects();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshPriorities();
    }

    public String getStatusColor() {
        return this.statusColor;
    }

    public void setStatusColor(String statusColor) {
        this.statusColor = statusColor;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    @Override
    public String getPageTitle() {
        return this.getText("admin.issuesettings.priorities.view.priorities");
    }

    @Override
    public String getTargetActionName() {
        return "EditPriority.jspa";
    }

    @Override
    public String getSubmitName() {
        return this.getText("common.forms.update");
    }

    @Override
    public String getTitle() {
        return this.getText("admin.issuesettings.priorities.edit.priority") + ": " + ((Priority)this.getConstant()).getName();
    }

    @Override
    public boolean isAddIdField() {
        return true;
    }
}

