/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.fields.option.ProjectOption;
import com.atlassian.jira.issue.priority.PrioritySchemeMigrateRequestHelper;
import com.atlassian.jira.issue.priority.PrioritySchemeMigratorFinder;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.type.ProjectTypeKeys;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuetypes.ExecutableAction;
import com.atlassian.jira.web.action.admin.priorities.AbstractManagePrioritiesAction;
import com.atlassian.jira.web.action.admin.priorities.PriorityManageableOption;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@WebSudoRequired
public class AssociatePriorityScheme
extends AbstractManagePrioritiesAction
implements ExecutableAction {
    private Long[] projects;
    private Boolean displaySDWarning;
    private List<Project> allProjectsOnInstance;
    private final ProjectManager projectManager;
    private final PageBuilderService pageBuilderService;
    private Collection<ProjectOption> availableProjects;
    private PrioritySchemeMigratorFinder prioritySchemeMigratorFinder;
    private PrioritySchemeMigrateRequestHelper prioritySchemeMigrateRequestHelper;

    public AssociatePriorityScheme(FieldConfigSchemeManager configSchemeManager, FieldManager fieldManager, PriorityManageableOption priorityManageableOption, PrioritySchemeManager prioritySchemeManager, PrioritySchemeService prioritySchemeService, ProjectManager projectManager, PageBuilderService pageBuilderService, PrioritySchemeMigratorFinder prioritySchemeMigratorFinder, PrioritySchemeMigrateRequestHelper prioritySchemeMigrateRequestHelper) {
        super(configSchemeManager, fieldManager, priorityManageableOption, prioritySchemeManager, prioritySchemeService);
        this.projectManager = projectManager;
        this.pageBuilderService = pageBuilderService;
        this.prioritySchemeMigratorFinder = prioritySchemeMigratorFinder;
        this.prioritySchemeMigrateRequestHelper = prioritySchemeMigrateRequestHelper;
    }

    public String doDefault() throws Exception {
        this.includeResources();
        FieldConfigScheme configScheme = this.getConfigScheme();
        List projectsList = configScheme.getAssociatedProjectObjects();
        this.setCurrentProjects(new HashSet(projectsList));
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Optional<String> migrationRedirect = this.migrationNeeded();
        if (migrationRedirect.isPresent()) {
            return migrationRedirect.get();
        }
        this.run();
        return this.getRedirect();
    }

    private String getMigrationUrl(Collection<Project> affectedProjects) {
        this.prioritySchemeMigrateRequestHelper.storeMigratePrioritySchemeRequest(new PrioritySchemeMigrateRequestHelper.MigratePrioritySchemeRequest(affectedProjects.stream().map(Project::getId).collect(Collectors.toList()), this.getSchemeId(), false));
        return "MigratePriorityScheme!default.jspa";
    }

    private Optional<String> migrationNeeded() throws SearchException {
        FieldConfigScheme targetScheme = this.prioritySchemeManager.getScheme(this.getSchemeId());
        List affectedProjects = this.getProjectKeys().stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObjByKey(arg_0)).filter(project -> !this.prioritySchemeMigratorFinder.findUnmappedPriorities((Project)project, targetScheme).isEmpty()).filter(project -> !Objects.equals(this.prioritySchemeManager.getScheme(project), targetScheme)).collect(Collectors.toList());
        if (affectedProjects.size() > 0) {
            return Optional.of(this.getRedirect(this.getMigrationUrl(this.getProjectsAsObjects())));
        }
        return Optional.empty();
    }

    private List<String> getProjectKeys() {
        return this.getProjectsAsObjects().stream().map(Project::getKey).collect(Collectors.toList());
    }

    public void run() {
        ServiceOutcome<FieldConfigScheme> serviceResult = this.prioritySchemeService.assignProjects(this.getLoggedInUser(), this.getConfigScheme(), this.getProjectsAsObjects());
        this.addErrorCollection(serviceResult.getErrorCollection());
    }

    public Collection<ProjectOption> getAllProjects() {
        if (this.availableProjects == null) {
            if (this.isDefault()) {
                FieldConfigScheme defaultPriorityScheme = this.prioritySchemeManager.getDefaultScheme();
                Collection projects = this.projectManager.getProjectObjects().stream().filter(this.projectNotUsingScheme(defaultPriorityScheme)).collect(Collectors.toList());
                this.availableProjects = ProjectOption.transform(projects);
            } else {
                List<Project> allProjects = this.getAllProjectsOnInstance();
                List<Project> filteredProjects = this.prioritySchemeService.filterProjectsNotPossibleToAssociate(allProjects);
                this.availableProjects = ProjectOption.transform(filteredProjects);
            }
        }
        return this.availableProjects;
    }

    private Predicate<Project> projectNotUsingScheme(FieldConfigScheme defaultPriorityScheme) {
        return project -> {
            FieldConfigScheme configScheme = this.prioritySchemeManager.getScheme(project);
            return !defaultPriorityScheme.equals(configScheme);
        };
    }

    public boolean isDisplaySDWarning() {
        if (this.displaySDWarning == null) {
            this.displaySDWarning = this.getAllProjectsOnInstance().stream().anyMatch(ProjectTypeKeys.projectTypePredicate(ProjectTypeKeys.SERVICE_DESK));
        }
        return this.displaySDWarning;
    }

    public Long[] getProjects() {
        return this.projects;
    }

    private Collection<Project> getProjectsAsObjects() {
        return Optional.ofNullable(this.projects).map(Arrays::asList).map(HashSet::new).orElse(new HashSet()).stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0)).collect(Collectors.toList());
    }

    private List<Project> getAllProjectsOnInstance() {
        if (this.allProjectsOnInstance == null) {
            this.allProjectsOnInstance = this.projectManager.getProjects();
        }
        return this.allProjectsOnInstance;
    }

    public void setProjects(Long[] projects) {
        this.projects = projects;
    }

    public void setCurrentProjects(Collection<? extends WithId> projects) {
        this.projects = (Long[])projects.stream().map(WithId::getId).toArray(Long[]::new);
    }

    public boolean isDefault() {
        return this.prioritySchemeManager.isDefaultScheme(this.getConfigScheme());
    }

    private void includeResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:administration-priority-schemes-resources");
    }
}

