/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import webwork.action.ActionContext;

@WebSudoRequired
public class AssociateFieldToScreens
extends JiraWebActionSupport {
    private String fieldId;
    private Long[] associatedTabs;
    private Long[] associatedScreens;
    private final FieldScreenManager fieldScreenManager;
    private final FieldManager fieldManager;

    public AssociateFieldToScreens(FieldManager fieldManager, FieldScreenManager fieldScreenManager) {
        this.fieldManager = fieldManager;
        this.fieldScreenManager = fieldScreenManager;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        List newScreens = this.getAssociatedScreens() != null ? Arrays.asList(this.getAssociatedScreens()) : Collections.emptyList();
        ArrayList<Long> newTabs = new ArrayList<Long>();
        Map actionParams = ActionContext.getParameters();
        if (this.associatedScreens != null) {
            for (Long screenId : this.associatedScreens) {
                Object o = actionParams.get(screenId.toString());
                String tabIdString = ((String[])o)[0];
                newTabs.add(new Long(tabIdString));
            }
        }
        List oldTabs = this.getStoredTabIdsForField() != null ? Arrays.asList(this.getStoredTabIdsForField()) : Collections.emptyList();
        List tabsToRemove = ListUtils.subtract(oldTabs, newTabs);
        for (Object aTabsToRemove : tabsToRemove) {
            Long tabId = (Long)aTabsToRemove;
            FieldScreenTab fieldScreenTab = this.fieldScreenManager.getFieldScreenTab(tabId);
            fieldScreenTab.getFieldScreen().removeFieldScreenLayoutItem(this.getFieldId());
        }
        List tabsToAdd = ListUtils.subtract(newTabs, oldTabs);
        for (Object aTabsToAdd : tabsToAdd) {
            Long tabId = (Long)aTabsToAdd;
            FieldScreenTab fieldScreenTab = this.fieldScreenManager.getFieldScreenTab(tabId);
            fieldScreenTab.addFieldScreenLayoutItem(this.getFieldId());
        }
        return this.getRedirect("ViewFieldScreens.jspa");
    }

    public Collection getScreens() {
        return this.fieldScreenManager.getFieldScreens();
    }

    private Long[] getStoredTabIdsForField() {
        ArrayList selectedTabs = new ArrayList(this.fieldScreenManager.getFieldScreenTabs(this.getField().getId()));
        Long[] newAssociatedTabs = null;
        if (selectedTabs != null && !selectedTabs.isEmpty()) {
            newAssociatedTabs = new Long[selectedTabs.size()];
            for (int i = 0; i < newAssociatedTabs.length; ++i) {
                FieldScreenTab tab = (FieldScreenTab)selectedTabs.get(i);
                newAssociatedTabs[i] = tab.getId();
            }
        }
        return newAssociatedTabs;
    }

    public FieldScreenTab selectedTabForScreen(FieldScreen screen) {
        if (screen.containsField(this.getFieldId())) {
            for (FieldScreenTab tab : screen.getTabs()) {
                if (tab.getFieldScreenLayoutItem(this.getFieldId()) == null) continue;
                return tab;
            }
        }
        return null;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public Long[] getAssociatedTabs() {
        return this.associatedTabs;
    }

    public void setAssociatedTabs(Long[] associatedTabs) {
        this.associatedTabs = associatedTabs;
    }

    public Long[] getAssociatedScreens() {
        return this.associatedScreens;
    }

    public void setAssociatedScreens(Long[] associatedScreens) {
        this.associatedScreens = associatedScreens;
    }

    public Field getField() {
        if (this.getFieldId() != null) {
            return this.fieldManager.getField(this.getFieldId());
        }
        return null;
    }
}

