/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.importer.project;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeyFormatter;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtilsImpl;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportBean;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportProgressTrackerUtil;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportWebAnalyticsService;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
public class ProjectImportResultsAction
extends JiraWebActionSupport {
    private static final Logger log = LoggerFactory.getLogger((String)"com.atlassian.jira.imports.project.ProjectImportResultsAction");
    ProjectImportResults projectImportResults;
    private final ProjectImportWebAnalyticsService projectImportWebAnalyticsService;
    private final ProjectImportProgressTrackerUtil progressTrackerUtil;

    public ProjectImportResultsAction(ProjectImportWebAnalyticsService projectImportWebAnalyticsService, JiraPageBuilderService jiraPageBuilderService, ProjectImportProgressTrackerUtil projectImportProgressTrackerUtil) {
        this.projectImportWebAnalyticsService = projectImportWebAnalyticsService;
        this.progressTrackerUtil = projectImportProgressTrackerUtil;
        this.progressTrackerUtil.requireAuiProgressTrackerResource(jiraPageBuilderService);
    }

    public String doDefault() throws Exception {
        this.projectImportWebAnalyticsService.publishAnalyticsEvent(this);
        return super.doDefault();
    }

    protected void doValidation() {
        super.doValidation();
        this.projectImportWebAnalyticsService.publishAnalyticsEvent(this);
        if (log.isDebugEnabled()) {
            System.gc();
            Map<String, String> stats = new ExtendedSystemInfoUtilsImpl((I18nHelper)this).getJvmStats();
            for (Map.Entry<String, String> e : stats.entrySet()) {
                log.debug(e.getKey() + " " + e.getValue());
            }
        }
        ProjectImportBean projectImportBean = ProjectImportBean.getProjectImportBeanFromSession();
        projectImportBean.setBackupOverview(null);
        projectImportBean.setProjectImportData(null);
        projectImportBean.setProjectImportOptions(null);
        projectImportBean.setMappingResult(null);
        projectImportBean.getTaskProgressInformation().setTaskId(null);
        if (projectImportBean.getTaskProgressInformation().getErrorCollection() != null) {
            this.addErrorCollection(projectImportBean.getTaskProgressInformation().getErrorCollection());
        }
    }

    public String doViewNewProject() {
        this.projectImportWebAnalyticsService.publishAnalyticsEvent(this);
        ProjectImportResults importResults = this.getProjectImportResults();
        if (importResults == null || importResults.getImportedProject() == null) {
            return this.getRedirect("/secure/admin/ProjectImportSelectBackup!default.jspa");
        }
        Project importedProject = importResults.getImportedProject();
        return this.getRedirect("/plugins/servlet/project-config/" + importedProject.getKey() + "/summary");
    }

    public ProjectImportResults getProjectImportResults() {
        if (this.projectImportResults == null) {
            this.projectImportResults = ProjectImportBean.getProjectImportBeanFromSession().getProjectImportResults();
        }
        return this.projectImportResults;
    }

    public String getAssigneeTypeString(Long assigneeType) {
        return this.getText(ProjectAssigneeTypes.getPrettyAssigneeType((Long)assigneeType));
    }

    public String getProjectEmail(Project project) throws Exception {
        return project.getEmail();
    }

    public String getPrettyImportDuration() {
        long durationInSeconds = this.getProjectImportResults().getImportDuration() / 1000L;
        return DateUtils.getDurationPretty((long)durationInSeconds, (ResourceBundle)this.getJiraServiceContext().getI18nBean().getDefaultResourceBundle());
    }

    public String getFormattedProjectType(ProjectTypeKey projectTypeKey) {
        return ProjectTypeKeyFormatter.format((ProjectTypeKey)projectTypeKey);
    }

    @ActionViewData
    public List<Map<String, Object>> getProgressTrackerSteps() {
        return this.progressTrackerUtil.getProgressTrackerSteps(ProjectImportProgressTrackerUtil.Page.SUMMARY);
    }
}

