/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;

@WebSudoRequired
public class ConfigureCustomField
extends JiraWebActionSupport {
    private Long customFieldId;
    private Long fieldId;
    private ManagedConfigurationItem managedConfigurationItem;
    private final FieldConfigSchemeManager schemeManager;
    private final CustomFieldManager customFieldManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final HelpUrls helpUrls;
    private static final String sprintCFTypeKey = "com.pyxis.greenhopper.jira:gh-sprint";

    public ConfigureCustomField(FieldConfigSchemeManager schemeManager, CustomFieldManager customFieldManager, ManagedConfigurationItemService managedConfigurationItemService, HelpUrls helpUrls) {
        this.schemeManager = schemeManager;
        this.customFieldManager = customFieldManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.helpUrls = helpUrls;
    }

    protected String doExecute() throws Exception {
        return "success";
    }

    public String doDelete() {
        return "delete";
    }

    public List<FieldConfigScheme> getConfigs() {
        if (this.getCustomFieldId() != null) {
            CustomField customField = this.getCustomField();
            return this.schemeManager.getConfigSchemesForField((ConfigurableField)customField);
        }
        return null;
    }

    @ActionViewData
    public CustomField getCustomField() {
        return this.customFieldManager.getCustomFieldObject(this.getCustomFieldId());
    }

    @ActionViewData
    public Long getCustomFieldId() {
        return this.customFieldId;
    }

    public void setCustomFieldId(Long customFieldId) {
        this.customFieldId = customFieldId;
    }

    @ActionViewData(value="delete")
    public Long getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(Long fieldId) {
        this.fieldId = fieldId;
    }

    public boolean isDefaultValueAllowed() {
        if (this.getCustomField() != null && this.getCustomField().getCustomFieldType() != null) {
            return !this.getCustomField().getCustomFieldType().getKey().equals(sprintCFTypeKey);
        }
        return true;
    }

    public boolean isFieldManaged() {
        return this.getManagedConfigurationItem().isManaged();
    }

    public boolean isFieldLocked() {
        return !this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), this.getManagedConfigurationItem());
    }

    public String getManagedFieldDescriptionKey() {
        return this.getManagedConfigurationItem().getDescriptionI18nKey();
    }

    public ManagedConfigurationItem getManagedConfigurationItem() {
        if (this.managedConfigurationItem == null) {
            this.managedConfigurationItem = this.managedConfigurationItemService.getManagedCustomField(this.getCustomField());
        }
        return this.managedConfigurationItem;
    }

    @ActionViewData(value="delete")
    public HelpUrl getDocumentationUrl() {
        return this.helpUrls.getUrl("customfields.configcustomfield");
    }

    @ActionViewData
    public String getXsrfToken() {
        return super.getXsrfToken();
    }
}

