/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.constants;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.constants.ConstantsValidationHelper;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class ConstantsValidationHelperImplement<T extends IssueConstant>
implements ConstantsValidationHelper<T> {
    private final I18nHelper i18n;

    public ConstantsValidationHelperImplement(I18nHelper i18n) {
        this.i18n = i18n;
    }

    @Override
    public SimpleErrorCollection validateName(String name, String id, String constantName, Collection<T> constants) {
        SimpleErrorCollection ec = new SimpleErrorCollection();
        if (StringUtils.isBlank((CharSequence)name)) {
            ec.addError("name", this.i18n.getText("admin.errors.must.specify.a.name.for.the.to.be.added", constantName));
        } else if (name.length() > 60) {
            ec.addError("name", this.i18n.getText("admin.common.errors.exceeds.max.name.length", (Object)60));
        } else {
            for (IssueConstant constant : constants) {
                if (!name.trim().equalsIgnoreCase(constant.getName()) || constant.getId().equals(id)) continue;
                ec.addError("name", this.i18n.getText("admin.errors.constant.already.exists"));
                break;
            }
        }
        return ec;
    }
}

