/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.constants;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.web.action.admin.constants.AbstractConstantAction;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;

public abstract class AbstractViewConstants<T extends IssueConstant>
extends AbstractConstantAction<T> {
    private Map<String, Object> fields;
    protected String up;
    protected String down;
    protected String name;
    protected String description;
    protected String iconurl;
    protected String make;
    private final TranslationManager translationManager;

    protected AbstractViewConstants(TranslationManager translationManager) {
        this.translationManager = translationManager;
    }

    public String doAddConstant() throws Exception {
        this.validateName(this.getName(), "", this.getNiceConstantName());
        if (this.invalidInput()) {
            return "error";
        }
        this.addConstant();
        return this.redirectToView();
    }

    protected abstract void addConstant() throws GenericEntityException;

    protected abstract String redirectToView();

    protected void addField(String key, Object value) {
        if (this.getFields() == null) {
            this.fields = new HashMap<String, Object>();
        }
        this.getFields().put(key, value);
    }

    private Map<String, Object> getFields() {
        return this.fields;
    }

    public boolean isDefault(IssueConstant constant) {
        String constantId = this.getDefaultId();
        return constantId != null && constant.getId().equals(constantId);
    }

    @Nullable
    protected String getDefaultId() {
        return this.getApplicationProperties().getString(this.getDefaultPropertyName());
    }

    protected abstract String getDefaultPropertyName();

    public void setUp(String up) {
        this.up = up;
    }

    public void setDown(String down) {
        this.down = down;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconurl() {
        return this.iconurl;
    }

    public void setIconurl(String iconurl) {
        this.iconurl = iconurl;
    }

    public void setMake(String make) {
        this.make = make;
    }

    public boolean isTranslatable() {
        return !this.translationManager.getInstalledLocales().isEmpty();
    }
}

