/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.constants;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueConstantImpl;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractConstantAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.GenericEntityException;

public abstract class AbstractDeleteConstant<T extends IssueConstant>
extends AbstractConstantAction<T> {
    protected String id;
    protected String newId;
    protected boolean confirm;
    private T constant;
    private List matchingIssues;

    protected void doValidation() {
        if (this.getConstant() == null) {
            this.addErrorMessage(this.getText("admin.errors.no.constant.found", this.getNiceConstantName(), this.id));
        }
        this.validateNewId();
    }

    protected void validateNewId() {
        if (!this.isNewIdValid()) {
            this.addError("newId", this.getText("admin.errors.specify.valid.constant.name", this.getNiceConstantName()));
        }
    }

    protected boolean isNewIdValid() {
        return this.newId != null && this.getConstant(this.newId) != null;
    }

    @RequiresXsrfCheck
    protected abstract String doExecute() throws Exception;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNewId() {
        return this.newId;
    }

    public void setNewId(String newId) {
        this.newId = newId;
    }

    public T getConstant() {
        if (this.constant == null) {
            this.constant = this.getConstant(this.id);
        }
        return this.constant;
    }

    public List getMatchingIssues() throws GenericEntityException {
        if (this.matchingIssues == null) {
            this.matchingIssues = ((IssueConstantImpl)((Object)this.getConstant())).getGenericValue().getRelated("ChildIssue");
            if (this.matchingIssues == null) {
                this.matchingIssues = Collections.emptyList();
            }
        }
        return this.matchingIssues;
    }

    public Collection<T> getNewConstants() {
        return this.getConstants().stream().filter(constant -> !this.id.equals(constant.getId())).collect(Collectors.toList());
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }
}

