/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.scheduler.SchedulerHistoryService;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import com.atlassian.scheduler.status.RunOutcome;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@WebSudoRequired
public class SchedulerAdmin
extends JiraWebActionSupport {
    private static final int HOURS_PER_DAY = 24;
    private static final int DAYS_PER_WEEK = 7;
    private static final int SLOW_JOBS_TO_SHOW = 200;
    private final SchedulerService schedulerService;
    private final SchedulerHistoryService schedulerHistoryService;
    private final PageBuilderService pageBuilderService;
    private final Set<JobRunnerKey> registeredJobRunners;
    private final JiraDurationUtils.DurationFormatter durationFormatter;

    public SchedulerAdmin(SchedulerService schedulerService, SchedulerHistoryService schedulerHistoryService, PageBuilderService pageBuilderService, I18nHelper i18nHelper) {
        this.schedulerService = schedulerService;
        this.schedulerHistoryService = schedulerHistoryService;
        this.pageBuilderService = pageBuilderService;
        this.durationFormatter = new JiraDurationUtils.PrettyDurationFormatter(24, 7, i18nHelper);
        this.registeredJobRunners = schedulerService.getRegisteredJobRunnerKeys();
    }

    protected String doExecute() throws Exception {
        this.pageBuilderService.assembler().resources().requireContext("scheduler-admin");
        return super.doExecute();
    }

    @ActionViewData(value="success")
    public List<JobRunnerWrapper> getJobRunners() {
        return this.schedulerService.getJobRunnerKeysForAllScheduledJobs().stream().map(jobRunnerKey -> new JobRunnerWrapper((JobRunnerKey)Assertions.notNull((Object)jobRunnerKey))).sorted().collect(Collectors.toList());
    }

    @ActionViewData(value="success")
    public List<JobDetailsWrapper> getJobDetails() {
        return this.schedulerService.getJobRunnerKeysForAllScheduledJobs().stream().flatMap(jobRunnerKey -> this.schedulerService.getJobsByJobRunnerKey(jobRunnerKey).stream()).flatMap(this::wrapJobDetails).sorted().limit(200L).collect(Collectors.toList());
    }

    private Stream<JobDetailsWrapper> wrapJobDetails(JobDetails jobDetails) {
        RunDetails lastRun = this.schedulerHistoryService.getLastRunForJob(jobDetails.getJobId());
        return lastRun != null ? Stream.of(new JobDetailsWrapper(jobDetails, lastRun)) : Stream.empty();
    }

    public class JobDetailsWrapper
    implements Comparable<JobDetailsWrapper> {
        private final JobDetails jobDetails;
        private final RunDetails lastRun;

        private JobDetailsWrapper(JobDetails jobDetails, RunDetails lastRun) {
            this.jobDetails = jobDetails;
            this.lastRun = lastRun;
        }

        @Nonnull
        public String getName() {
            return this.jobDetails.getJobId().toString();
        }

        @Nonnull
        public String getGroup() {
            return this.jobDetails.getJobRunnerKey().toString();
        }

        @Nonnull
        public JobId getJobId() {
            return this.jobDetails.getJobId();
        }

        public boolean isRunLocally() {
            return this.jobDetails.getRunMode() == RunMode.RUN_LOCALLY;
        }

        @Nonnull
        public String getSchedule() {
            Schedule schedule = this.jobDetails.getSchedule();
            switch (schedule.getType()) {
                case CRON_EXPRESSION: {
                    return schedule.getCronScheduleInfo().getCronExpression();
                }
                case INTERVAL: {
                    long intervalInMillis = schedule.getIntervalScheduleInfo().getIntervalInMillis();
                    return intervalInMillis == 0L ? SchedulerAdmin.this.getText("admin.schedulerdetails.run.once") : this.formatDuration(intervalInMillis);
                }
            }
            return schedule.toString();
        }

        @CheckForNull
        public Date getNextRunTime() {
            return this.jobDetails.getNextRunTime();
        }

        @Nonnull
        public String getParameters() {
            return this.jobDetails.getParameters().toString();
        }

        public boolean isRunnable() {
            return this.jobDetails.isRunnable();
        }

        @Nonnull
        public String getLastRunTime() {
            return this.lastRun != null ? this.lastRun.getStartTime().toString() : "";
        }

        public long getLastRunDurationRaw() {
            return this.lastRun != null ? this.lastRun.getDurationInMillis() : 0L;
        }

        @Nonnull
        public String getLastRunDuration() {
            return this.lastRun != null ? this.formatDuration(this.lastRun.getDurationInMillis()) : "";
        }

        @Nonnull
        public String formatDuration(Long milliseconds) {
            if (milliseconds < 1000L) {
                return SchedulerAdmin.this.getText("admin.schedulerdetails.milliseconds", milliseconds);
            }
            return SchedulerAdmin.this.durationFormatter.format(Long.valueOf(milliseconds / 1000L));
        }

        @Nonnull
        public String getLastRunMessage() {
            return this.lastRun != null ? this.lastRun.getMessage() : "";
        }

        public RunDetails getLastRun() {
            return this.lastRun;
        }

        @Nullable
        public String getStatusIcon() {
            if (this.lastRun != null) {
                return this.lastRun.getRunOutcome() == RunOutcome.SUCCESS ? "success" : "error";
            }
            return null;
        }

        @Nullable
        public String getParametersOrException() {
            try {
                return String.valueOf(this.jobDetails.getParameters());
            }
            catch (SchedulerRuntimeException sre) {
                return SchedulerAdmin.this.getText("admin.schedulerdetails.cannot.access.parameters");
            }
        }

        @Override
        public int compareTo(JobDetailsWrapper o) {
            return Long.compare(o.getLastRunDurationRaw(), this.getLastRunDurationRaw());
        }
    }

    public class JobRunnerWrapper
    implements Comparable<JobRunnerWrapper> {
        private final JobRunnerKey jobRunnerKey;
        private final List<JobDetailsWrapper> jobs = Lists.newArrayList();
        private final int numberOfFailedJobs;
        private final Set<String> schedule = Sets.newTreeSet();

        public JobRunnerWrapper(JobRunnerKey jobRunnerKey) {
            this.jobRunnerKey = jobRunnerKey;
            block4: for (JobDetails jobDetails : SchedulerAdmin.this.schedulerService.getJobsByJobRunnerKey(jobRunnerKey)) {
                this.jobs.add(new JobDetailsWrapper(jobDetails, SchedulerAdmin.this.schedulerHistoryService.getLastRunForJob(jobDetails.getJobId())));
                switch (jobDetails.getSchedule().getType()) {
                    case CRON_EXPRESSION: {
                        this.schedule.add(SchedulerAdmin.this.getText("admin.schedulerdetails.schedule.cron"));
                        continue block4;
                    }
                    case INTERVAL: {
                        this.schedule.add(SchedulerAdmin.this.getText("admin.schedulerdetails.schedule.interval"));
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("unknown scheduler type " + jobDetails.getSchedule().getType());
            }
            this.numberOfFailedJobs = this.countNumberOfFailedJobs(this.jobs);
        }

        protected int countNumberOfFailedJobs(List<JobDetailsWrapper> jobs) {
            int numberOfFailedJobs = 0;
            for (JobDetailsWrapper job : jobs) {
                if (job.getLastRun() == null || job.getLastRun().getRunOutcome() == RunOutcome.SUCCESS) continue;
                ++numberOfFailedJobs;
            }
            return numberOfFailedJobs;
        }

        @Nonnull
        public Set<String> getSchedule() {
            return this.schedule;
        }

        @Nonnull
        public JobRunnerKey getKey() {
            return this.jobRunnerKey;
        }

        @Nonnull
        public List<JobDetailsWrapper> getJobs() {
            return this.jobs;
        }

        public int getNumberOfSuccessfulJobs() {
            return this.jobs.size() - this.getNumberOfFailedJobs();
        }

        public int getNumberOfFailedJobs() {
            return this.numberOfFailedJobs;
        }

        @Nonnull
        public String getStatusIcon() {
            if (this.numberOfFailedJobs == this.jobs.size()) {
                return "error";
            }
            if (this.numberOfFailedJobs > 0) {
                return "warning";
            }
            return "success";
        }

        public boolean isRemoveable() {
            return !SchedulerAdmin.this.registeredJobRunners.contains(this.jobRunnerKey);
        }

        @Override
        public int compareTo(JobRunnerWrapper o) {
            return this.getKey().toString().compareToIgnoreCase(o.getKey().toString());
        }
    }
}

