/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.issue.archiving.ArchivedIssueSearchService;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.rest.json.SuggestionBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.SuggestionBean;
import com.atlassian.jira.issue.fields.rest.json.beans.SuggestionGroupBean;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedStatistics;
import com.atlassian.jira.project.archiving.ArchivingLicenseCheck;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.action.util.FieldsResourceIncluder;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

@WebSudoRequired
public class ExportArchivedIssues
extends ProjectActionSupport {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final FeatureManager featureManager;
    private final FieldsResourceIncluder fieldsResourceIncluder;
    private final PageBuilderService pageBuilderService;
    private final ArchivingLicenseCheck archivingLicenseCheck;
    private final HelpUrls helpUrls;
    private final ArchivedStatistics archivedStatistics;
    private final ProjectManager projectManager;
    private final SuggestionBeanFactory suggestionBeanFactory;
    private final I18nHelper i18nHelper;
    private final ArchivedIssueSearchService searchService;
    private Integer maxResults;
    private String projectKey;
    private String reporter;
    private String issueType;
    private String archivedBy;
    private Long archivedBefore;
    private Long archivedAfter;

    public ExportArchivedIssues(FeatureManager featureManager, FieldsResourceIncluder fieldsResourceIncluder, PageBuilderService pageBuilderService, ArchivingLicenseCheck archivingLicenseCheck, HelpUrls helpUrls, ArchivedStatistics archivedStatistics, ProjectManager projectManager, SuggestionBeanFactory suggestionBeanFactory, I18nHelper i18nHelper, ArchivedIssueSearchService searchService) {
        this.featureManager = featureManager;
        this.fieldsResourceIncluder = fieldsResourceIncluder;
        this.pageBuilderService = pageBuilderService;
        this.archivingLicenseCheck = archivingLicenseCheck;
        this.helpUrls = helpUrls;
        this.archivedStatistics = archivedStatistics;
        this.projectManager = projectManager;
        this.suggestionBeanFactory = suggestionBeanFactory;
        this.i18nHelper = i18nHelper;
        this.searchService = searchService;
    }

    public String doDownload() {
        ArchivedIssueSearchService.ArchiveSearchRequest request = new ArchivedIssueSearchService.ArchiveSearchRequest().setMaxResults(this.maxResults).setArchivedAfter(this.archivedAfter).setArchivedBefore(this.archivedBefore).setArchivedBy(this.archivedBy).setIssueType(this.issueType).setProjectKeyOrId(this.projectKey).setReporter(this.reporter);
        ArchivedIssueSearchService.ValidationResult validation = this.searchService.validateSearch(request);
        if (!validation.isValid()) {
            this.addErrorCollection(validation.getErrorCollection());
            return "error";
        }
        ImmutableList params = ImmutableList.of((Object)"maxResults", (Object)"projectKey", (Object)"reporter", (Object)"issueType", (Object)"archivedBy", (Object)"archivedBefore", (Object)"archivedAfter");
        String query = params.stream().filter(name -> StringUtils.isNotEmpty((CharSequence)this.getHttpRequest().getParameter(name))).map(name -> name + "=" + JiraUrlCodec.encode((String)this.getHttpRequest().getParameter(name))).collect(Collectors.joining("&"));
        return this.returnCompleteWithInlineRedirect("/rest/internal/2/archiving?" + query);
    }

    public String doDefault() {
        if (!this.archivingLicenseCheck.isLicensedForIssueArchiving()) {
            return "error";
        }
        this.fieldsResourceIncluder.includeFieldResourcesForCurrentUser();
        this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:jira-fields");
        return "input";
    }

    @ActionViewData
    public int getTotalArchived() {
        return this.archivedStatistics.getTotalArchivedIssuesCount();
    }

    @ActionViewData
    public String getProjectSuggestionJson() throws IOException {
        SuggestionGroupBean archivedProjects = new SuggestionGroupBean(this.i18nHelper.getText("admin.export.archived.issues.archived.projects"), this.suggestionBeanFactory.projectSuggestions(this.projectManager.getArchivedProjects(), Optional.empty()));
        SuggestionGroupBean activeProjects = new SuggestionGroupBean(this.i18nHelper.getText("admin.export.archived.issues.active.projects"), this.suggestionBeanFactory.projectSuggestions(this.projectManager.getProjects(), Optional.empty()));
        SuggestionGroupBean allProjects = new SuggestionGroupBean("", (Collection)ImmutableList.of((Object)new SuggestionBean(this.i18nHelper.getText("admin.export.archived.issues.all.projects"), "", "", true)));
        return mapper.writeValueAsString((Object)ImmutableList.of((Object)archivedProjects, (Object)activeProjects, (Object)allProjects));
    }

    @ActionViewData
    public String getIssueTypeSuggestionJson() throws IOException {
        SuggestionGroupBean issueTypes = new SuggestionGroupBean(this.i18nHelper.getText("admin.export.archived.issues.issuetypes"), this.suggestionBeanFactory.optionSuggestions(this.getConstantsManager().getAllIssueTypeObjects().stream().map(IssueConstantOption::new).collect(Collectors.toList()), Optional.empty()));
        SuggestionGroupBean allIssueTypes = new SuggestionGroupBean("", (Collection)ImmutableList.of((Object)new SuggestionBean(this.i18nHelper.getText("admin.export.archived.issues.all.issuetypes"), "", "", true)));
        return mapper.writeValueAsString((Object)ImmutableList.of((Object)issueTypes, (Object)allIssueTypes));
    }

    @ActionViewData
    public String getDocumentationUrl() {
        return this.helpUrls.getUrl("export.archived.issues").getUrl();
    }

    @ActionViewData
    public boolean getFiltersEnabled() {
        return this.featureManager.isEnabled(JiraFeatureFlagRegistrar.ARCHIVED_ISSUES_FILTERS);
    }

    @ActionViewData
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    public void setArchivedBy(String archivedBy) {
        this.archivedBy = archivedBy;
    }

    public void setArchivedBefore(Long archivedBefore) {
        this.archivedBefore = archivedBefore;
    }

    public void setArchivedAfter(Long archivedAfter) {
        this.archivedAfter = archivedAfter;
    }
}

