/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import io.atlassian.fugue.Option;

public class AdminUserDataProvider
implements WebResourceDataProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext = this.getJiraAuthenticationContext();
    private final GlobalPermissionManager globalPermissionManager = this.getGlobalPermissionManager();
    private static final String IS_ADMIN = "isAdmin";
    private static final String IS_SYS_ADMIN = "isSysAdmin";

    public Jsonable get() {
        return writer -> {
            try {
                this.getJsonData().write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }

    private JSONObject getJsonData() throws JSONException {
        JSONObject values = new JSONObject();
        if (this.canAccessComponents()) {
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            values.put(IS_SYS_ADMIN, this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user));
            values.put(IS_ADMIN, this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user));
        }
        return values;
    }

    private boolean canAccessComponents() {
        return this.jiraAuthenticationContext != null && this.globalPermissionManager != null;
    }

    private GlobalPermissionManager getGlobalPermissionManager() {
        return AdminUserDataProvider.getComponentOrNull(GlobalPermissionManager.class);
    }

    private JiraAuthenticationContext getJiraAuthenticationContext() {
        return AdminUserDataProvider.getComponentOrNull(JiraAuthenticationContext.class);
    }

    private static <T> T getComponentOrNull(Class<T> clazz) {
        Option componentOption = Option.option(ComponentAccessor.getComponentSafely(clazz).orElse(null));
        return (T)componentOption.getOrNull();
    }
}

