/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ActionContext;

public abstract class JiraWizardActionSupport
extends JiraWebActionSupport {
    protected int currentStep = 1;
    protected String submitBtn;
    protected String finishButton;
    private static final String BUTTON_NAME_NEXT = "nextBtn";
    private static final String BUTTON_NAME_PREVIOUS = "previousBtn";

    protected String doExecute() throws Exception {
        if (this.isPreviousClicked()) {
            --this.currentStep;
        } else if (!this.isFinishClicked() && this.isNextClicked()) {
            ++this.currentStep;
        }
        return super.doExecute();
    }

    protected boolean isPreviousClicked() {
        return this.isButtonClickedByName(BUTTON_NAME_PREVIOUS);
    }

    protected boolean isNextClicked() {
        return this.isButtonClickedByName(BUTTON_NAME_NEXT);
    }

    protected boolean isFinishClicked() {
        return this.isNextClicked() && this.getCurrentStep() >= this.getTotalSteps();
    }

    protected boolean isButtonClickedByValue(String buttonValue) {
        String str = this.getSubmitBtn();
        if (str == null) {
            return false;
        }
        return str.toLowerCase().contains(buttonValue.toLowerCase());
    }

    protected boolean isButtonClickedByName(String name) {
        return StringUtils.isNotBlank((CharSequence)ParameterUtils.getStringParam((Map)ActionContext.getParameters(), (String)name));
    }

    public abstract int getTotalSteps();

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public String getSubmitBtn() {
        return this.submitBtn;
    }

    public void setSubmitBtn(String submitBtn) {
        this.submitBtn = submitBtn;
    }

    public String getFinishButton() {
        return this.finishButton;
    }

    public void setFinishButton(String finishButton) {
        this.finishButton = finishButton;
    }
}

